//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "MakeTblU.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm2::CreateBtnClick(TObject *Sender)
{
  // Utwrz alias BDE.
  const char* dir = "c:\\mydata";
  CreateDirectory(dir, 0);
  try {
    Session->AddStandardAlias("MyDatabase", dir, "PARADOX");
    Session->SaveConfigFile();
  }
  catch (...) {
    MessageBox(Handle, "Bd tworzenia aliasu", "Bd", 0);
    return;
  }

  Screen->Cursor = crHourGlass;
  // Utwrz tabel.
  TTable* table;
  try {
    table = new TTable(this);
    table->DatabaseName = "MyDatabase";
    table->TableName = "MyTable.db";

    // Utwrz definicje pl tabeli.
    table->FieldDefs->Add("CustNo", ftFloat, 0, true);
    table->FieldDefs->Add("Customer", ftString, 30, false);
    table->FieldDefs->Add("Addr1", ftString, 30, false);
    table->FieldDefs->Add("Addr2", ftString, 30, false);
    table->FieldDefs->Add("City", ftString, 15, false);
    table->FieldDefs->Add("State", ftString, 20, false);
    table->FieldDefs->Add("Zip", ftString, 10, false);
    table->FieldDefs->Add("Phone", ftString, 15, false);
    table->FieldDefs->Add("Fax", ftString, 15, false);

    // Zdefiniuj indeks gwny.
    table->IndexDefs->Add(
      "", "CustNo", TIndexOptions() << ixPrimary);

    // Wszystko gotowe, mona fizycznie utworzy tabel.
    table->CreateTable();
  }
  catch (...) {
    MessageBox(Handle, "Bd tworzenia tabeli", "Bd", 0);
    Screen->Cursor = crDefault;
    delete table;
    return;
  }

  // Koniec operacji - daj zna uytkownikowi.
  delete table;
  Screen->Cursor = crDefault;
  CreateBtn->Enabled = false;
  FillBtn->Enabled = true;
  MessageBox(Handle, "Tabela zostaa utworzona", "OK!", 0);
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FillBtnClick(TObject *Sender)
{
  // Utwrz obiekt klasy TTable.
  TTable* table = new TTable(this);
  table->DatabaseName = "MyDatabase";
  table->TableName = "MyTable.db";

  // Utwrz rdo danych i pocz je z tabel.
  // Nastpnie pocz komponent DBGrid ze rdem.
  TDataSource* datasource = new TDataSource(this);
  datasource->DataSet = table;
  DBGrid->DataSource = datasource;

  // Otwrz tabel i plik z danymi.
  table->Active = true;
  TStringList* lines = new TStringList;
  lines->LoadFromFile("customer.txt");
  String S;

  // Ustaw tabel w tryb edycji.
  table->Edit();

  // Czytaj kolejne wiersze...
  for (int i=0;i<lines->Count;i++) {

    // Docz rekord do koca tabeli.
    table->Append();

    // Pobierz pierwsze pole z acucha.
    S = lines->Strings[i];
    int pos = S.Pos(",");
    String S2 = S.SubString(1, pos - 1);
    S.Delete(1, pos);

    // Zapisz pobran warto do pola CustNo.
    table->FieldByName("CustNo")->Value = S2.ToInt();

    // Zrb to samo dla pozostaych pl.
    pos = S.Pos(",");
    S2 = S.SubString(1, pos - 1);
    S.Delete(1, pos);
    table->FieldByName("Customer")->Value = S2;

    pos = S.Pos(",");
    S2 = S.SubString(1, pos - 1);
    S.Delete(1, pos);
    table->FieldByName("Addr1")->Value = S2;

    pos = S.Pos(",");
    S2 = S.SubString(1, pos - 1);
    S.Delete(1, pos);
    table->FieldByName("Addr2")->Value = S2;

    pos = S.Pos(",");
    S2 = S.SubString(1, pos - 1);
    S.Delete(1, pos);
    table->FieldByName("City")->Value = S2;

    pos = S.Pos(",");
    S2 = S.SubString(1, pos - 1);
    S.Delete(1, pos);
    table->FieldByName("State")->Value = S2;

    pos = S.Pos(",");
    S2 = S.SubString(1, pos - 1);
    S.Delete(1, pos);
    table->FieldByName("Zip")->Value = S2;

    pos = S.Pos(",");
    S2 = S.SubString(1, pos - 1);
    S.Delete(1, pos);
    table->FieldByName("Phone")->Value = S2;

    pos = S.Pos(",");
    S2 = S.SubString(1, pos - 1);
    S.Delete(1, pos);
    table->FieldByName("FAX")->Value = S2;

    // Prba dodania rekordu o tym samym numerze klienta moe
    // spowodowa bd klucza. W takiej sytuacji naley
    // powiadomi uytkownika, anulowa wprowadzone zmiany,
    // ustawi tabel w trybie edycji i kontynuowa.
    try {
      table->Post();
    }
    catch (EDBEngineError& E) {
      MessageBox(0, "Powielony numer klienta", "Bd klucza", 0);
      table->Cancel();
      table->Edit();
      continue;
    }
  }

  // Usu niepotrzebn ju list acuchw.
  delete lines;

  // Aby dane z tabeli zostay wywietlone w arkuszu, nie naley
  // jej usuwa. Zrobi to za nas VCL.
  //delete table;
  //delete datasource;
}
//---------------------------------------------------------------------------
