//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "RegMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
  //
  // Zainicjalizuj zmienn keyDeleted na false.
  // Stane tej zmiennej sygnalizuje usunicie klucza
  // przez uytkownika (zobacz funkcj MainFormClose()).
  //
  keyDeleted = false;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  //
  // Utwrz obiekt klasy TRegistry.
  //
  TRegistry& regKey = *new TRegistry();
  //
  // Otwrz klucz.
  //
  bool keyGood = regKey.OpenKey(
    "Software\\Helion\\C++Builder", false);
  //
  // Sprawd, czy klucz jest otwarty. Jeli program nie by
  // wczeniej uruchamiany, nic nie rb; w przeciwnym
  // przypadku odczytaj z klucza informacj inicjalizacyjn
  // aplikacji.
  //
  if (!keyGood) return;
  int top = regKey.ReadInteger("Top");
  int left = regKey.ReadInteger("Left");
  int width = regKey.ReadInteger("Width");
  int height = regKey.ReadInteger("Height");
  SetBounds(left, top, width, height);
  WindowState =
    TWindowState(regKey.ReadInteger("WindowState"));
  //
  // Klasa DateTime przydaje si w programowaniu
  // operacji na wartociach daty i czasu.
  //
  TDateTime dt;
  dt = regKey.ReadDate("Date and Time");
  DateLabel->Caption = dt.DateString();
  TimeLabel->Caption = dt.TimeString();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FileOpenClick(TObject *Sender)
{
  //
  // Wywietla okienko dialogowe otwarcia pliku, ale
  // nie otwiera go. Kliknicie OK powoduje w zamian
  // zapisanie maski, cieki i nazwy pliku do rejestru
  //
  //
  // Utwrz obiekt klasy TRegistry.
  //
  TRegistry& regKey = *new TRegistry();
  //
  // Otwrz klucz.
  //
  regKey.OpenKey(
    "Software\\Helion\\C++Builder", true);
  //
  // Odczytaj dane z klucza; jeli nie zostay
  // wczeniej utworzone, nastpi zgoszenie wyjtku...
  //
  try {
    OpenDialog->InitialDir = regKey.ReadString("LastDir");
    OpenDialog->FileName = regKey.ReadString("LastFile");
    OpenDialog->FilterIndex = regKey.ReadInteger("FilterIndex");
  }
  //
  // ... ktry w naszym przypadku mona zignorowa
  // (ale oczywicie naley go przechwyci).
  //
  catch (...) {}
  //
  // Wywietl pole dialogowe otwarcia pliku;
  // po klikniciu OK zapisz ciek, mask i nazw
  // pliku do rejestru.
  //
  if (OpenDialog->Execute()) {
    String path;
    String fname;
    //
    // Rozdziel nazw pliku i ciek.
    //
    ParseFileName(path, fname);
    regKey.WriteString("LastDir", path);
    regKey.WriteString("LastFile", fname);
    regKey.WriteInteger
      ("FilterIndex", OpenDialog->FilterIndex);
  }
}
//---------------------------------------------------------------------------

void TMainForm::ParseFileName(String& path, String& fname)
{
  //
  // Wydziela z penej cieki nazw katalogu.
  //
  int pos = 0;
  String s = OpenDialog->FileName;
  int x = 1;
  while (x) {
    x = s.Pos("\\");
    s = s.SubString(x + 1, s.Length() - x);
    pos += x;
  }
  fname = s;
  path = OpenDialog->FileName.SubString(0, pos);
}
void __fastcall TMainForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  //
  // Jeli uytkownik klikn przycisk usunicia klucza,
  // nie bdziemy zapisywa informacji w rejestrze.
  //
  if (keyDeleted) return;
  //
  // Utwrz obiekt klasy TRegistry.
  //
  TRegistry& regKey = *new TRegistry();
  //
  // Otwrz klucz.
  //
  regKey.OpenKey(
    "Software\\Helion\\C++Builder", true);
  //
  // Zapisz dane do klucza.
  //
  regKey.WriteInteger("WindowState", WindowState);
  if (WindowState != wsMaximized) {
    regKey.WriteInteger("Top", Top);
    regKey.WriteInteger("Left", Left);
    regKey.WriteInteger("Width", Width);
    regKey.WriteInteger("Height", Height);
  }
  TDateTime dt;
  regKey.WriteDate("Date and Time", dt.CurrentDateTime());
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FileExitClick(TObject *Sender)
{
  //
  // do zobaczenia...
  //
  Close();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DeleteKeyClick(TObject *Sender)
{
  //
  // Po klikniciu przycisku Usu klucz naley usun
  // klucz z rejestru i ustawi odpowiedni znacznik,
  // aby nie zosta on ponownie utworzony.
  //
  TRegistry& regKey = *new TRegistry();
  regKey.DeleteKey("Software\\Helion");
  keyDeleted = true;
}
//---------------------------------------------------------------------------


