//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "SPMain.h"
#include "SPAbout.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TScratchPad *ScratchPad;
//---------------------------------------------------------------------------
__fastcall TScratchPad::TScratchPad(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileExitClick(TObject *Sender)
{
  //
  // Koniec pracy - zamykamy okno gwne.
  //
  Close();  
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditCutClick(TObject *Sender)
{
  //
  //  Wywoaj metod TMemo::CutToClipboard().
  //
  Memo->CutToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditCopyClick(TObject *Sender)
{
  //
  //  Wywoaj metod TMemo::CopyToClipboard().
  //
  Memo->CopyToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditPasteClick(TObject *Sender)
{
  //
  //  Wywoaj metod TMemo::PasteFromClipboard().
  //
  Memo->PasteFromClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileNewClick(TObject *Sender)
{
  //
  // Tworzy nowy dokument. Przed utworzeniem zachowuje
  // w razie potrzeby biec zawarto edytora.
  //
  if (Memo->Modified) {
  //
  // Wywietl okienko dialogowe z pytaniem.
  //
    int result = Application->MessageBox(
        "Biecy dokument zosta zmieniony. Czy zachowa zmiany?",
        "Uwaga", MB_YESNOCANCEL | MB_ICONWARNING);
    //
    // Kliknito przycisk Tak
    //
       if (result == IDYES) FileSaveClick(Sender);
    //
    // If No was clicked then do nothing.
    //
    // Kliknito przycisk Nie
  }
  //
  // Usu wszystkie wiersze w polu edycyjnym
  //
  if (Memo->Lines->Count > 0) Memo->Clear();
  //
  // Ustaw waciwo FileName pola zapisania pliku
  // na pusty acuch. Oznacza to, e tekst jeszcze
  // nie zosta zachowany.
  //
 SaveDialog->FileName = "";
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileOpenClick(TObject *Sender)
{
  //
  // Otwiera plik, uprzednio zachowujc poprzedni
  // zawarto edytora.
  //
  if (Memo->Modified) {
    int result = Application->MessageBox(
      "Biecy dokument zosta zmieniony. Czy zachowa zmiany?",
      "Uwaga", MB_YESNOCANCEL | MB_ICONWARNING);
      if (result == IDYES) FileSaveClick(0);
    if (result == IDCANCEL) return;
  }
  //
  // Wywietla okienko dialogowe otwarcia pliku. Usuwa zawarto
  // waciwoci FileName. Jeli kliknito OK, otwiera plik za
  // pomoc metody LoadFromFile().
  //
  OpenDialog->FileName = "";
  if (OpenDialog->Execute())
  {
    if (Memo->Lines->Count > 0) Memo->Clear();
     Memo->Lines->LoadFromFile(OpenDialog->FileName);
    SaveDialog->FileName = OpenDialog->FileName;
  }
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileSaveClick(TObject *Sender)
{
  //
  // Jeeli wczeniej podano nazw, nie ma potrzeby
  // otwierania pola dialogowego zapisywania pliku.
  // Mona od razu wywoa metod SaveToFile().
  //
  if (SaveDialog->FileName != "")
  {
    Memo->Lines->SaveToFile(SaveDialog->FileName);
    //
    // Zerujemy znacznik modyfikacji - plik zosta ju zapisany.
    //
    Memo->Modified = false;
  }
  //
  // Nie podano nazwy pliku - trzeba zapyta uytkownika.
  //
  else FileSaveAsClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::FileSaveAsClick(TObject *Sender)
{
  //
  // Wywietla okienko dialogowe zapisania pliku.
  // Zeruje znacznik modyfikacji - plik zosta zapisany.
  //
  SaveDialog->Title = "Zapisz jako";
  if (SaveDialog->Execute())
  {
    Memo->Lines->SaveToFile(SaveDialog->FileName);
    Memo->Modified = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditUndoClick(TObject *Sender)
{
  //
  // Poniewa komponent TMemo nie posiada metody obsugujcej
  // polecenie Cofnij, musimy uy komunikatu WM_UNDO Windows.
  //
  SendMessage(Memo->Handle, WM_UNDO, 0, 0);
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditSelectAllClick(TObject *Sender)
{
  //
  //  Wywoaj metod TMemo::SelectAll().
  //
  Memo->SelectAll();
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::EditWordWrapClick(TObject *Sender)
{
  //
  // Przecz stan waciwoci TMemo::WordWrap.
  // Po przeczeniu zaznacz nowy stan w menu Edycja.
  //
  Memo->WordWrap = !Memo->WordWrap;
  EditWordWrap->Checked = Memo->WordWrap;
  //
  // Jeli dzielenie wierszy jest wczone, wystarczy pionowy
  // pasek przewijania, w przeciwnym przypadku obydwa.
  //
  if (Memo->WordWrap) Memo->ScrollBars = ssVertical;
  else Memo->ScrollBars = ssBoth;
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::OnHint(TObject* Sender)
{
  StatusBar->SimpleText = Application->Hint;
}
void __fastcall TScratchPad::FormCreate(TObject *Sender)
{
  Application->OnHint = OnHint;  
}
//---------------------------------------------------------------------------
void __fastcall TScratchPad::HelpAboutClick(TObject *Sender)
{
  AboutBox->ShowModal();  
}
//---------------------------------------------------------------------------

