//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "BTMain.h"
#include "BitBtn.h"
#include "Button.h"
//---------------------------------------------------------------------------

#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ShowButtonsClick(TObject *Sender)
{
  int result;
  String text;
  if (Sender == ShowButtons || Sender == BtnsSpeedBtn)
    result = ButtonForm->ShowModal();
  else result = BitBtnForm->ShowModal();
  switch (result) {
    case mrOk     : text = "OK"; break;
    case mrCancel : text = "Anuluj"; break;
    case mrAbort  : text = "Przerwij"; break;
    case mrRetry  : text = "Powtrz"; break;
    case mrIgnore : text = "Ignoruj"; break;
    case mrYes    : text = "Tak"; break;
    case mrNo     : text = "Nie"; break;
    case mrAll    : text = "Wszystko"; break;
    default : text = "Specjalny";
  }
  String msgText =
    "Nacisne przycisk " + text + ".";
  Label->Caption = msgText;

}
//---------------------------------------------------------------------
void __fastcall TMainForm::AllowAllUpBoxClick(TObject *Sender)
{
  DrawMode->AllowAllUp = AllowAllUpBox->Checked;
}
//---------------------------------------------------------------------
void __fastcall TMainForm::DrawModeClick(TObject *Sender)
{
  String s = "Tryb: ";
  TSpeedButton* button = dynamic_cast<TSpeedButton*>(Sender);
  if (button) s += button->Hint;
  if (!DrawMode->Down && !PaintMode->Down && !EraseMode->Down)
    s = "Tryb: brak";
  ModeLabel->Caption = s;
}
//---------------------------------------------------------------------