//---------------------------------------------------------------------------
#ifndef FlashTstH
#define FlashTstH
//---------------------------------------------------------------------------
#include <vcl\SysUtils.hpp>
#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Forms.hpp>
#include <vcl\StdCtrls.hpp>
//---------------------------------------------------------------------------
//
// Definicja nowego typu dla funkcji obsugi zdarzenia.
// Parametry funkcji s typu TObject* i bool&.
//
typedef void __fastcall
  (__closure *TMyEvent)(System::TObject *Sender, bool& Stop);

class PACKAGE TFlashingLabel : public TCustomLabel
{
private:
  //
  // Pola prywatne
  //
  bool  FFlashEnabled;
  int   FFlashRate;
  int   FFlashLimit;
  int   FlashCount;
  TMyEvent FOnLimitReached;
  TTimer* Timer;
protected:
  //
  // Chronione metody zapisu dla pl prywatnych
  //
  void __fastcall SetFlashEnabled(bool AFlashEnabled);
  void __fastcall SetFlashRate(int AFlashRate);
  //
  // Funkcja LimitReached() (wyzwalajca zdarzenie)
  //
  virtual void __fastcall LimitReached();
  //
  // Metoda Click() zostaa przedefiniowana dla polazania
  // sposobu redefinicji metody klasy bazowej. Jest ona
  // funkcj wirtualn i bdzie wywoywana w wyniku
  // kadego kliknicia komponentu.
  //
  __declspec(dynamic) void __fastcall Click()
  {
    //
    // Wygeneruj krtki dwik i przeka sterowanie do funkcji
    // Click() klasy bazowej.
   //
    MessageBeep(-1);
    TCustomLabel::Click();
  }
  //
  // Funkcja obsugi zdarzenia OnTimer
  //
  virtual void __fastcall OnTimer(TObject* Sender);
public:
	__fastcall TFlashingLabel(TComponent* Owner);
__published:
  //
  // Waciwoci komponentu
  //
  __property bool FlashEnabled =
    {read=FFlashEnabled, write=SetFlashEnabled, default=true};
  __property int FlashRate =
    {read=FFlashRate, write=SetFlashRate, default=800};
  __property int FlashLimit =
    {read=FFlashLimit, write=FFlashLimit, default=0};
  //
  // Zdarzenie OnLimitReached
  //
  __property TMyEvent OnLimitReached =
    {read=FOnLimitReached, write=FOnLimitReached};
};
//---------------------------------------------------------------------------
#endif
