//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "DbQueryU.h"
//---------------------------------------------------------------------------
#pragma package(smart_init);
#pragma resource "*.dfm"
TForm4 *Form4;
//---------------------------------------------------------------------------
__fastcall TForm4::TForm4(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm4::FormCreate(TObject *Sender)
{
  Session->GetDatabaseNames(DBNamesComboBox->Items);
}
//---------------------------------------------------------------------------

void __fastcall TForm4::DBNamesComboBoxChange(TObject *Sender)
{
  if (Query1->Active)
    Query1->Active = false;
  if (Database1->Connected)
    Database1->Close();
  TablesComboBox->Text = "";
  String DBName = DBNamesComboBox->Text;
  Database1->DatabaseName = DBName;
  if (Database1->IsSQLBased)
    Session->GetTableNames(DBName, "",
      false, true, TablesComboBox->Items);
  else
    Session->GetTableNames(DBName, "",
      true, false, TablesComboBox->Items);
  Query1->DatabaseName = DBName;
  TablesComboBox->DroppedDown = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm4::TablesComboBoxChange(TObject *Sender)
{
  if (TablesComboBox->Text == "") return;
  String S = "Select * from " + TablesComboBox->Text;
  Query1->SQL->Clear();
  Query1->SQL->Add(S);
  Query1->Open();
  FieldsComboBox->Enabled = true;
  ValueEdit->Enabled = true;
  Query1->GetFieldNames(FieldsComboBox->Items);
  FieldsComboBox->Text = FieldsComboBox->Items->Strings[0];
}
//---------------------------------------------------------------------------
void __fastcall TForm4::SQLBtnClick(TObject *Sender)
{
  Query1->SQL->Clear();
  Query1->SQL->Add(SQLEdit->Text);
  Query1->Open();
}
//---------------------------------------------------------------------------
void __fastcall TForm4::FilterBtnClick(TObject *Sender)
{
  TLocateOptions SearchOptions;
  SearchOptions << loPartialKey;
  Query1->Locate(FieldsComboBox->Text, ValueEdit->Text, SearchOptions);
}
//---------------------------------------------------------------------------
void __fastcall TForm4::Database1Login(TDatabase *Database,
      TStrings *LoginParams)
{
  LoginParams->Values["user name"] = UserNameEdit->Text;
  LoginParams->Values["password"] = PasswordEdit->Text;
}
//---------------------------------------------------------------------------
void __fastcall TForm4::SQLEditKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  if (Key == VK_RETURN) {
    SQLBtnClick(Sender);
    SQLEdit->SelectAll();
  }
}
//---------------------------------------------------------------------------
