//---------------------------------------------------------------------------
#include <condefs.h>
#include <iostream.h>
#include <conio.h>
#pragma hdrstop
//---------------------------------------------------------------------------
USERES("Airport.res");
USEUNIT("airplane.cpp");
//---------------------------------------------------------------------
#include "airplane.h"
int getInput(int max);
void getItems(int& speed, int& dir, int& alt);
int main(int /*argc*/, char /***argv*/)
{
  char returnMsg[100];
  //
  // Utwrz tablic trzech obiektw typu Airplane
  // reprezentujcych samoloty
  //
  Airplane* planes[3];
  planes[0] = new Airplane("TWA 1040");
  planes[1] = new Airplane("United Express 749", COMMUTER);
  planes[2] = new Airplane("Cessna 3238T", PRIVATE);
  //
  // Gwna ptla programu
  //
  do {
    int plane, message, speed, altitude, direction;
    speed = altitude = direction = -1;
    //
    // Wybr odbiorcy komunikatu
    // Uytkownik wybiera samolot z wywietlonej listy
    //
    cout << endl << "Wybierz odbiorce komunikatu:";
    cout << endl << endl << "0. Koniec pracy" <<  endl;
    for (int i=0;i<3;i++)
      cout << (i + 1) << ". " << planes[i]->name << endl;
    //
    // Wprowadzenie numeru samolotu funkcj getInput()
    //
    plane = getInput(4);
    //
    // Opcja 0 oznacza zakoczenie pracy
    //
    if (plane == -1) break;
    //
    // Samolot potwierdza wywoanie
    //
    cout << endl << "Tu " << planes[plane]->name << ", odbir.";
    cout << endl << endl;
    //
    // Wybr komunikatu do wysania
    //
    cout << "Wybierz komunikat:" << endl;
    cout << endl << "0. Koniec" << endl;;
    cout << "1. Zmiana parametrw lotu" << endl;
    cout << "2. Start" << endl;
    cout << "3. Ldowanie" << endl;
    cout << "4. Raport o parametrach lotu" << endl;
    message = getInput(5);
    //
    // Opcja 0 oznacza zakoczenie pracy
    //
    if (message == -1) break;
    //
    // Opcja 1 wymaga wprowadzenia
    // nowych wartoci prdkoci, kursu i wysokoci.
    // Robi to funkcja getItems().
    //
    if (message == 0)
      getItems(speed, direction, altitude);
    //
    // Wylij komunikat do samolotu
    //
    bool goodMsg = planes[plane]->SendMessage(
      message, returnMsg, speed, direction, altitude);
    //
    // Nie zrealizowano przekazanego polecenia
    //
    if (!goodMsg) cout << endl << planes[plane]->name
                  << ": Nie mog wykona polecenia.";
    //
    // Wywietl odpowied samolotu
    //
    cout << endl << returnMsg << endl;
  } while (1);
  //
  // Usu obiekty reprezentujce samoloty
  //
  for (int i=0;i<3;i++) delete planes[i];
}
int getInput(int max)
{
  int choice;
  do {
    choice = getch();
    choice -= 49;
  } while (choice < -1 || choice > max);
  return choice;
}
void getItems(int& speed, int& dir, int& alt)
{
  cout << endl << "Podaj now prdko: ";
  getch();
  cin >> speed;
  cout << "Podaj nowy kurs: ";
  cin >> dir;
  cout << "Podaj now wysoko: ";
  cin >> alt;
  cout << endl;
}
//---------------------------------------------------------------------------
