//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "WebBrwsU.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TWebMain *WebMain;
//---------------------------------------------------------------------------
__fastcall TWebMain::TWebMain(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::URLComboBoxClick(TObject *Sender)
{
  if (URLComboBox->Text != "")
    HTML->RequestDoc(URLComboBox->Text);
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::URLComboBoxKeyPress(TObject *Sender, char &Key)
{
  if (Key == VK_RETURN) {
    Key = 0;
    if (URLComboBox->Text == "") return;
    URLComboBoxClick(Sender);
  }
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::HTMLUpdateRetrieval(TObject *Sender)
{
  int total = HTML->RetrieveBytesTotal;
  int done = HTML->RetrieveBytesDone;
  int percent;
  if (total == 0 || done == 0)
    percent = 0;
  else
    percent = ((done * 100) / total);
  char buff[80];
  wsprintf(buff,
    "Pobieranie dokumentu: %d%% z %dK", percent, total/1024);
  StatusBar->SimpleText = buff;
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::HTMLEndRetrieval(TObject *Sender)
{
  StatusBar->SimpleText = "Gotowe";
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::GoBtnClick(TObject *Sender)
{
  URLComboBoxClick(0);
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::StopBtnClick(TObject *Sender)
{
  HTML->Cancel(0);
  StatusBar->SimpleText = "Przerwano";
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::ReloadBtnClick(TObject *Sender)
{
  URLComboBoxClick(0);
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::SourceBtnClick(TObject *Sender)
{
  HTML->ViewSource = !HTML->ViewSource;
  if (HTML->ViewSource)
    SourceBtn->Caption = "Dokument";
  else
    SourceBtn->Caption = "rdo";
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::HTMLDoRequestDoc(TObject *Sender,
      const WideString URL, const HTMLElement *Element,
      const DocInput *DocInput, WordBool &EnableDefault)
{
  StatusBar->SimpleText = "czenie z adresem " + URL + "...";
}
//---------------------------------------------------------------------------
void __fastcall TWebMain::HTMLBeginRetrieval(TObject *Sender)
{
  StatusBar->SimpleText = "Poczono.";
  URLComboBox->Items->Insert(0, URLComboBox->Text);
}
//---------------------------------------------------------------------------
