// HostInfoImpl : Implementation of THostInfoImpl (CoClass: HostInfo, Interface: IHostInfo)

#include <vcl.h>
#pragma hdrstop

#include "HostInfoImpl.h"

/////////////////////////////////////////////////////////////////////////////
// THostInfoImpl

STDMETHODIMP THostInfoImpl::get_Info(BSTR* Value)
{
	try {
		*Value = NULL;

		char lpBuffer[MAX_COMPUTERNAME_LENGTH + 1];
		unsigned long lngSize = sizeof(lpBuffer);

		if (GetComputerName(lpBuffer, &lngSize) == 0)
            return HRESULT_FROM_WIN32(GetLastError());

		WideString strInfo = AnsiString().sprintf("Data i czas na %s: %s",
                                                  lpBuffer, DateTimeToStr(Now()));

		*Value = strInfo.Detach();
	}
	catch(Exception &e) {
		return Error(e.Message.c_str(), IID_IHostInfo);
	}
	return S_OK;
};

