#include <vcl.h>
#pragma hdrstop
#include "MainUnit.h"

#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmMain *frmMain;

__fastcall TfrmMain::TfrmMain(TComponent* Owner) : TForm(Owner)
{
}

void __fastcall TfrmMain::FrmMain_Close(TObject *Sender, TCloseAction &Action)
{
	m_objHost.Unbind();
}

void __fastcall TfrmMain::FrmMain_Create(TObject *Sender)
{
	char szBuffer[MAX_COMPUTERNAME_LENGTH + 1];
	unsigned long lngSize = sizeof(szBuffer);

	GetComputerName(szBuffer, &lngSize);

	txtLocal->Text = AnsiString().sprintf("Data i czas na %s: %s",
                                          szBuffer, DateTimeToStr(Now()));
}

void __fastcall TfrmMain::CmdFinish_Click(TObject *Sender)
{
	Close();
}

void __fastcall TfrmMain::CmdInfo_Click(TObject *Sender)
{
	if (!m_objHost.IsBound()) {
        AnsiString strHost;

        if (InputQuery("Informacja", "Podaj nazw komputera:", strHost)) {
            if (strHost.IsEmpty())
                OleCheck(CoHostInfo::Create(m_objHost));
            else
                OleCheck(CoHostInfo::CreateRemote(WideString(strHost), m_objHost));

            WideString strInfo;
            OleCheck(m_objHost.get_Info(&strInfo));

            txtRemote->Text = strInfo;
        }
    }
}

