#include <vcl.h>
#pragma hdrstop
#include "MainUnit.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TfrmMain *frmMain;

__fastcall TfrmMain::TfrmMain(TComponent* Owner) : TForm(Owner)
{
    m_AuthInfo.Flags    = SEC_WINNT_AUTH_IDENTITY_ANSI;
    m_AuthInfo.User     = NULL;
    m_AuthInfo.Domain   = NULL;
    m_AuthInfo.Password = NULL;
}

void __fastcall TfrmMain::FrmMain_Close(TObject *Sender, TCloseAction &Action)
{
    m_objBlanket.Unbind();

    delete[] m_AuthInfo.User;
    delete[] m_AuthInfo.Domain;
    delete[] m_AuthInfo.Password;
}

void __fastcall TfrmMain::CmdCallServer_Click(TObject *Sender)
{
    if (!m_objBlanket.IsBound()) {
        AnsiString strHost;

        if (InputQuery("Create Server", "Podaj nazw komputera:", strHost)) {
            if (strHost.IsEmpty())
                OleCheck(CoObjBlanket::Create(m_objBlanket));
            else
                OleCheck(CoObjBlanket::CreateRemote(WideString(strHost),
                                                    m_objBlanket));
            ShowMessage("Utworzono serwer.");
        }
    }
}

void __fastcall TfrmMain::CmdCreateFile_Click(TObject *Sender)
{
    if (m_objBlanket.IsBound()) {
        AnsiString strFile;

        if (InputQuery("Create File", "Podaj ciek do pliku:", strFile)) {
            OleCheck(m_objBlanket.CreateFile(WideString(strFile)));
            ShowMessage("Utworzono plik.");
        }
    }
}

void __fastcall TfrmMain::CmdFinish_Click(TObject *Sender)
{
    Close();
}

void __fastcall TfrmMain::CmdGetInfo_Click(TObject *Sender)
{
    if (m_objBlanket.IsBound())
		GetAuthInfo();
}

void __fastcall TfrmMain::CmdIdentity_Click(TObject *Sender)
{
    gbxIdn->Enabled = rdoIdnty->Checked ? true : false;

    txtDomain->Color = rdoIdnty->Checked ? clWindow : clBtnFace;
    txtPwrd  ->Color = rdoIdnty->Checked ? clWindow : clBtnFace;
    txtUser  ->Color = rdoIdnty->Checked ? clWindow : clBtnFace;
}

void __fastcall TfrmMain::CmdSetIdentity_Click(TObject *Sender)
{
    if (m_objBlanket.IsBound()) {
        if (rdoIdnty->Checked)
            SetAuthInfo();

        OleCheck(CoSetProxyBlanket(m_objBlanket,
                                   RPC_C_AUTHN_WINNT,
                                   RPC_C_AUTHZ_NONE,
                                   NULL,
                                   RPC_C_AUTHN_LEVEL_CONNECT,
                                   RPC_C_IMP_LEVEL_IMPERSONATE,
                                   rdoIdnty->Checked ? &m_AuthInfo :NULL,
                                   EOAC_NONE));
    }
}

void TfrmMain::GetAuthInfo()
{
	WideString strInfo;
	OleCheck(m_objBlanket.BlanketInfo(&strInfo));
	txtInfo->Text = strInfo;
}

void TfrmMain::SetAuthInfo()
{
    delete[] m_AuthInfo.User;
    delete[] m_AuthInfo.Domain;
    delete[] m_AuthInfo.Password;

    m_AuthInfo.UserLength     = txtUser  ->Text.Length();
    m_AuthInfo.DomainLength   = txtDomain->Text.Length();
    m_AuthInfo.PasswordLength = txtPwrd  ->Text.Length();

    m_AuthInfo.User     = (PUCHAR)new TCHAR[txtUser  ->Text.Length()+1];
    m_AuthInfo.Domain   = (PUCHAR)new TCHAR[txtDomain->Text.Length()+1];
    m_AuthInfo.Password = (PUCHAR)new TCHAR[txtPwrd  ->Text.Length()+1];

    lstrcpy((LPTSTR)m_AuthInfo.User    , (LPCTSTR)txtUser  ->Text.c_str());
    lstrcpy((LPTSTR)m_AuthInfo.Domain  , (LPCTSTR)txtDomain->Text.c_str());
    lstrcpy((LPTSTR)m_AuthInfo.Password, (LPCTSTR)txtPwrd  ->Text.c_str());
}
