// ZODIACIMPL : Implementation of TZodiacImpl (CoClass: Zodiac, Interface: IZodiac)

#include <vcl.h>
#pragma hdrstop

#include "ZODIACIMPL.H"
#include "ZODIACDATA.H"

/////////////////////////////////////////////////////////////////////////////
// TZodiacImpl

STDMETHODIMP TZodiacImpl::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] =
	{
		&IID_IZodiac
	};
	for (int i=0; i < (sizeof(arr) / sizeof(arr[0])); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

static TCOMCriticalSection CS;

static void GetZodiacSign(long Day, long Month, BSTR& Sign)
{
  unsigned short year = ((Month == 1) && (Day <= 19)) ? 2001 : 2000;
  static const LPCTSTR SQL =
    _T("SELECT Name FROM ZODIAC WHERE (CAST(\"%s\" AS DATE) BETWEEN StartingDate AND EndingDate)");
  TDateTime BirthDay(year,
                     static_cast<unsigned short>(Month),
                     static_cast<unsigned short>(Day));
  ZodiacDataModule->QZodiac->Active = FALSE;
  ZodiacDataModule->QZodiac->SQL->Clear();
  ZodiacDataModule->QZodiac->SQL->Add(
    //Format(SQL, ARRAYOFCONST((FormatDateTime(ShortDateFormat, BirthDay).c_str()))));
    Format(SQL, ARRAYOFCONST(( BirthDay.DateString().c_str() ))) );
  ZodiacDataModule->QZodiac->Active = TRUE;

  if (ZodiacDataModule->QZodiac->RecordCount != 1)
    throw Exception(_T("Invalid arguments"));

  ZodiacDataModule->QZodiac->First();
  WideString wstrSign =
    ZodiacDataModule->QZodiac->FieldByName(_T("Name"))->AsString.c_str();
  Sign = wstrSign.Detach();
}

struct TDetailedZodiacSignImpl : public TDetailedZodiacSign
{
   TDetailedZodiacSignImpl()
   {
      Sign = NULL;
      Element = NULL;
      Element = NULL;
      Planet = NULL;
      Details = NULL;
      Details = NULL;
      Advice = NULL;
   }
   ~TDetailedZodiacSignImpl()
   {
      if (Sign != NULL)
        SysFreeString(Sign);
      if (Element != NULL)
        SysFreeString(Element);
      if (Planet != NULL)
        SysFreeString(Planet);
      if (Details != NULL)
        SysFreeString(Details);
      if (Advice != NULL)
        SysFreeString(Advice);
   }
};

static void GetDetailedZodiacSign(long Day, long Month,
                                  TDetailedZodiacSign& DetailedSign)
{
  unsigned short year = ((Month == 1) && (Day <= 19)) ? 2001 : 2000;
  static const LPCTSTR SQL =
    _T("SELECT * FROM ZODIAC WHERE (CAST(\"%s\" AS DATE) BETWEEN StartingDate AND EndingDate)");
  TDateTime BirthDay(year,
                     static_cast<unsigned short>(Month),
                     static_cast<unsigned short>(Day));
  ZodiacDataModule->QZodiac->Active = FALSE;
  ZodiacDataModule->QZodiac->SQL->Clear();
  ZodiacDataModule->QZodiac->SQL->Add(
    //Format(SQL, ARRAYOFCONST((FormatDateTime(ShortDateFormat, BirthDay).c_str()))));
    Format(SQL, ARRAYOFCONST(( BirthDay.DateString().c_str() ))) );
  ZodiacDataModule->QZodiac->Active = TRUE;

  if (ZodiacDataModule->QZodiac->RecordCount != 1)
    throw Exception(_T("Invalid arguments"));

  ZodiacDataModule->QZodiac->First();

  {
    WideString wstrValue =
      ZodiacDataModule->QZodiac->FieldByName(_T("Name"))->AsString.c_str();
    DetailedSign.Sign = wstrValue.Detach();
  }

  {
    WideString wstrValue =
      ZodiacDataModule->QZodiac->FieldByName(_T("Planet"))->AsString.c_str();
    DetailedSign.Planet = wstrValue.Detach();
  }

  {
    WideString wstrValue =
      ZodiacDataModule->QZodiac->FieldByName(_T("Element"))->AsString.c_str();
    DetailedSign.Element = wstrValue.Detach();
  }

  {
    WideString wstrValue =
      ZodiacDataModule->QZodiac->FieldByName(_T("Description"))->AsString.c_str();
    DetailedSign.Details = wstrValue.Detach();
  }

  {
    WideString wstrValue =
      ZodiacDataModule->QZodiac->FieldByName(_T("Advice"))->AsString.c_str();
    DetailedSign.Advice = wstrValue.Detach();
  }

  {
    DetailedSign.House =
      ZodiacDataModule->QZodiac->FieldByName(_T("Id"))->AsInteger;
  }
}

STDMETHODIMP TZodiacImpl::GetZodiacSign(long Day, long Month, BSTR* Sign)
{
  try
  {
    TCOMCriticalSection::Lock Lock(CS);

    ::GetZodiacSign(Day, Month, *Sign);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IZodiac, E_FAIL);
  }
  return S_OK;
}

STDMETHODIMP TZodiacImpl::GetZodiacSignAsync(long Day, long Month)
{
  try
  {
    TCOMCriticalSection::Lock Lock(CS);

    BSTR Sign = NULL;
    ::GetZodiacSign(Day, Month, Sign);
    Fire_OnZodiacSignReady(Sign);
    SysFreeString(Sign);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IZodiac, E_FAIL);
  }
  return S_OK;
};

STDMETHODIMP TZodiacImpl::GetDetailedZodiacSign(long Day, long Month,
  TDetailedZodiacSign* DetailedSign)
{
  try
  {
    TCOMCriticalSection::Lock Lock(CS);

    ::GetDetailedZodiacSign(Day, Month, *DetailedSign);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IDetailedZodiac, E_FAIL);
  }
  return S_OK;
};

STDMETHODIMP TZodiacImpl::GetDetailedZodiacSignAsync(long Day, long Month)
{
  try
  {
    TCOMCriticalSection::Lock Lock(CS);

    TDetailedZodiacSignImpl DetailedSign;
    ::GetDetailedZodiacSign(Day, Month, DetailedSign);
	  Fire_OnDetailedZodiacSignReady(&DetailedSign);
  }
  catch(Exception &e)
  {
    return Error(e.Message.c_str(), IID_IDetailedZodiac, E_FAIL);
  }
  return S_OK;
};



