#if !defined(ZODIACCUSTOMSINK_H__)
#define ZODIACCUSTOMSINK_H__

#include <atlvcl.h>
#include <atlbase.h>
#include <atlcom.h>
#include <ComObj.HPP>
#include <utilcls.h>
#include "CustomSinks.h"
#include "ZodiacServer_TLB.h"

typedef void __fastcall (__closure * TDetailedZodiacSignReadyEvent)
    (TDetailedZodiacSign& DetailedSign);

//---------------------------------------------------------------------------
// Klasa implementujca interfejs IDetailedZodiacEvents
class ATL_NO_VTABLE TDetailedZodiacSinkImpl :
  public CComObjectRootEx<CComSingleThreadModel>,
  public CComCoClass<TDetailedZodiacSinkImpl, &CLSID_NULL>,
  public IDetailedZodiacEvents
{
public:
  TDetailedZodiacSinkImpl() :
    FOnDetailedZodiacSign(NULL)
  {
  }

  DECLARE_THREADING_MODEL(otApartment);

BEGIN_COM_MAP(TDetailedZodiacSinkImpl)
  COM_INTERFACE_ENTRY(IDetailedZodiacEvents)
END_COM_MAP()

protected:
  // Zdarzenie
  TDetailedZodiacSignReadyEvent FOnDetailedZodiacSign;

public:
  __property TDetailedZodiacSignReadyEvent OnDetailedZodiacSign =
    { read = FOnDetailedZodiacSign, write = FOnDetailedZodiacSign };

// IDetailedZodiacEvents
public:
  STDMETHOD(OnDetailedZodiacSignReady(TDetailedZodiacSign* DetailedSign))
  {
    if (FOnDetailedZodiacSign != NULL)
      FOnDetailedZodiacSign(*DetailedSign);
    return S_OK;
  }

};

typedef TCustomSink<TDetailedZodiacSinkImpl,
    IDetailedZodiacEvents, &IID_IDetailedZodiacEvents>
      TZodiacCustomSink;

#endif //ZODIACCUSTOMSINK_H__
