// ANYTHINGIMPL : Implementation of TAnythingImpl (CoClass: Anything, Interface: IAnything)

#include <vcl.h>
#pragma hdrstop

#include "..\ComThrow.h"
#include "ANYTHINGIMPL.H"

/////////////////////////////////////////////////////////////////////////////
// TAnythingImpl

// ISupportErrorInfo
STDMETHODIMP TTestErrorsImpl::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] =
	{
		&IID_ITestErrors
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

// ITestErrors
STDMETHODIMP TTestErrorsImpl::ConvertToString(long Number, BSTR* String)
{
  HRESULT hResult = S_OK;

  try
  {
     BCHECK_FMT(String != NULL, E_POINTER,
      _T("acuch musi by rny od NULL"));
     
     WideString strWide(IntToStr(Number));
     *String = strWide.Detach();
  }
  catch(ECOMError &e)
  {
    hResult = Error(e.Message, IID_ITestErrors, e.ErrorCode);
  }
  catch(Exception &e)
  {
    hResult = Error(e.Message.c_str(), IID_ITestErrors, E_FAIL);
  }
  catch(...)
  {
    hResult = Error(_T("Hm... tego si nie spodziewaem!"),
                    IID_ITestErrors, E_UNEXPECTED);
  }

  return hResult;
}


STDMETHODIMP TTestErrorsImpl::RichErrorMethod()
{
  HRESULT hResult = S_OK;

  try
  {
    static int k = 0;

    switch(++k)
    {
      case 1:
      {
         HCHECK(E_NOINTERFACE);
         break;
      }
      case 2:
      {
         OFSTRUCT ofs;
         WINAPI_BCHECK(OpenFile(_T("I nie istnieje"), &ofs, OF_EXIST) != HFILE_ERROR);
         break;
      }
      case 3:
      {
         HKEY hKey = NULL;
         WINAPI_CHECK(RegOpenKeyEx(NULL, "I nie istnieje",
                     0, KEY_ALL_ACCESS, &hKey));
         break;
      }
      default:
      {
         k = 0;
         HCHECK_FMT(E_FAIL,
           _T("Ten tekst jest dostpny dla klientw potraficych odczyta rozszerzon informacj o bdzie."));
         break;
      }
    }
  }
  catch(ECOMError &e)
  {
    hResult = Error(e.Message, IID_ITestErrors, e.ErrorCode);
  }

  return hResult;
};


