// ANYTHINGIMPL.H : Declaration of the TAnythingImpl

#ifndef AnythingImplH
#define AnythingImplH

#include "ErrorServer_TLB.h"


/////////////////////////////////////////////////////////////////////////////
// TAnythingImpl     Implements IAnything, default interface of Anything
// ThreadingModel : Apartment
// Dual Interface : FALSE
// Event Support  : FALSE
// Default ProgID : Project2.Anything
// Description    : 
/////////////////////////////////////////////////////////////////////////////
class ATL_NO_VTABLE TTestErrorsImpl :
  public CComObjectRootEx<CComSingleThreadModel>,
  public CComCoClass<TTestErrorsImpl, &CLSID_TestErrors>,
  public ITestErrors,
  public ISupportErrorInfo
{
public:
  TTestErrorsImpl()
  {
  }

  // Data used when registering Object 
  //
  DECLARE_THREADING_MODEL(otApartment);
  DECLARE_PROGID("ErrorServer.TestErrors");
  DECLARE_DESCRIPTION("");

  // Function invoked to (un)register object
  //
  static HRESULT WINAPI UpdateRegistry(BOOL bRegister)
  {
    TTypedComServerRegistrarT<TTestErrorsImpl>
    regObj(GetObjectCLSID(), GetProgID(), GetDescription());
    return regObj.UpdateRegistry(bRegister);
  }


BEGIN_COM_MAP(TTestErrorsImpl)
  COM_INTERFACE_ENTRY(ITestErrors)
  COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
public:
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IAnything
public:
 
  STDMETHOD(ConvertToString(long Number, BSTR* String));
  STDMETHOD(RichErrorMethod());
};

#endif //AnythingImplH
