using System;
using ordersInterfaces;
using System.Collections;

namespace ordersMemory
{
	public class CustomerMgrMem : ICustomerMgr
	{
		Hashtable hsItems = new Hashtable();
		ArrayList arrKeys = new ArrayList();

		public CustomerMgrMem()
		{
		}

		public void RemoveCustomer(string ID)
		{
			arrKeys.Remove(ID);
			hsItems.Remove(ID);
		}

		public ICustomer CreateNew()
		{
			ICustomer customer = new Customer();
			customer.ID = Guid.NewGuid().ToString();
			return customer;
		}
		
		public string AddCustomer(ICustomer customer)
		{
			hsItems.Add(customer.ID,customer);
			arrKeys.Add(customer.ID);
			return customer.ID;
		}
		
		public ICustomer this[int Index]
		{
			get
			{
				string key = (string)arrKeys[Index];
				ICustomer customer = (ICustomer)hsItems[key];
				return customer;
			}
		}

		public ICustomer this[string ID]
		{
			get
			{
				ICustomer customer = (ICustomer)hsItems[ID];
				return customer;
			}
		}

		public int Count
		{
			get
			{
				return arrKeys.Count;
			}
		}
	}

}
