using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ordersInterfaces;
using System.Reflection;

namespace ordersystem
{
	/// <summary>
	/// Summary description for customers.
	/// </summary>
	public class customers : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label lblTitle;
		protected System.Web.UI.WebControls.Label lblName;
		protected System.Web.UI.WebControls.TextBox txtName;
		protected System.Web.UI.WebControls.DataGrid grdCustomers;
		protected System.Web.UI.WebControls.Button btnAdd;
		protected System.Web.UI.WebControls.HyperLink lnkMenu;
		ICustomerMgr mgr;
	
		void RefreshGrid()
		{
			int count = mgr.Count;
			ArrayList list = new ArrayList();

			if (count > 0)
			{
				for (int index = 0; index < count; index++)
				{
					ICustomer customer = mgr[index];
					list.Add(customer);
				}
			}

			grdCustomers.DataSource = list;
			grdCustomers.DataBind();
		}

		void PrepareCustomerGrid()
		{
			//the code for this function
			//will be added later in the 
			//chapter
			HyperLinkColumn linkcol = new HyperLinkColumn();
			linkcol.Text = "View Orders";
			linkcol.HeaderText = "View Orders";
			linkcol.DataNavigateUrlField = "ID";
			linkcol.DataNavigateUrlFormatString="orders.aspx?ID={0}";
			grdCustomers.Columns.Add(linkcol);

			ButtonColumn buttoncol = new ButtonColumn();
			buttoncol.Text = "Delete";
			buttoncol.CommandName = "Delete";
			buttoncol.HeaderText = "Delete";
			grdCustomers.Columns.Add(buttoncol);
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			mgr = utilities.CreateCustomerManager(); 
			PrepareCustomerGrid();
			RefreshGrid();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.grdCustomers.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.grdCustomers_DeleteCommand);
			this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			ICustomer customer = mgr.CreateNew();
			customer.Name = txtName.Text;
			mgr.AddCustomer(customer);
			txtName.Text = "";
			RefreshGrid();
		}

		private void grdCustomers_DeleteCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			string item = e.Item.Cells[0].Text;
			mgr.RemoveCustomer(item);
			RefreshGrid();
		}

	}

}
