using System;
using ordersInterfaces;
using System.Web;
using System.Reflection;

namespace ordersystem
{
	/// <summary>
	/// Summary description for utilities.
	/// </summary>
	public class utilities
	{
		static public ICustomerMgr CreateCustomerManager()
		{
			ICustomerMgr retVal = (ICustomerMgr)HttpContext.Current.Session["__CustomerMgr"];
			if (retVal == null)
			{
				string ordersDLL = System.Configuration.ConfigurationSettings.AppSettings["OrdersDLL"];
				string className = System.Configuration.ConfigurationSettings.AppSettings["CustomerMgrClass"];

				string path = HttpContext.Current.Server.MapPath(ordersDLL);
				Assembly ad = Assembly.LoadFrom(path);
				retVal = (ICustomerMgr)ad.CreateInstance(className);
				HttpContext.Current.Session["__CustomerMgr"]=retVal;
			}
			return retVal;
		}
		
		static public IInventoryMgr CreateInventoryManager()
		{
			IInventoryMgr retVal = (IInventoryMgr)HttpContext.Current.Session["__InventoryMgr"];
			if (retVal == null)
			{
				string ordersDLL = System.Configuration.ConfigurationSettings.AppSettings["OrdersDLL"];
				string className = System.Configuration.ConfigurationSettings.AppSettings["InventoryMgrClass"];

				string path = HttpContext.Current.Server.MapPath(ordersDLL);
				Assembly ad = Assembly.LoadFrom(path);
				retVal = (IInventoryMgr)ad.CreateInstance(className);
				HttpContext.Current.Session["__InventoryMgr"]=retVal;
			}
			return retVal;
		}
		
		static public IOrderMgr CreateOrderManager()
		{
			IOrderMgr retVal = (IOrderMgr)HttpContext.Current.Session["__OrderMgr"];
			if (retVal == null)
			{
				string ordersDLL = System.Configuration.ConfigurationSettings.AppSettings["OrdersDLL"];
				string className = System.Configuration.ConfigurationSettings.AppSettings["OrderMgrClass"];

				string path = HttpContext.Current.Server.MapPath(ordersDLL);
				Assembly ad = Assembly.LoadFrom(path);
				retVal = (IOrderMgr)ad.CreateInstance(className);
				HttpContext.Current.Session["__OrderMgr"]=retVal;
			}
			return retVal;
		}
	}
}
