using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Reflection;

namespace LoadFunctions
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class WebForm1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Button btnLoadFull;
		protected System.Web.UI.WebControls.Label lblResult;
		protected System.Web.UI.WebControls.Label Label1;
		protected System.Web.UI.WebControls.TextBox txtFullyQualifiedName;
		protected System.Web.UI.WebControls.TextBox txtPartiallyQualifiedName;
		protected System.Web.UI.WebControls.Button btnLoadFrom;
		protected System.Web.UI.WebControls.TextBox txtPath;
		protected System.Web.UI.WebControls.DataGrid grdResults;
		protected System.Web.UI.WebControls.Button btnLoadPartial;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnLoadFull.Click += new System.EventHandler(this.btnLoadFull_Click);
			this.btnLoadFrom.Click += new System.EventHandler(this.btnLoadFrom_Click);
			this.btnLoadPartial.Click += new System.EventHandler(this.btnLoadPartial_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void WriteReport(System.Reflection.Assembly ad)
		{
			lblResult.Text = "Location: " + ad.Location.ToString() + "<br>" +
				"Version: " +ad.GetName().Version.ToString();

			DataTable dt = new DataTable("class report");
			dt.Columns.Add("class",typeof(string));
			dt.Columns.Add("member",typeof(string));
			dt.Columns.Add("type",typeof(string));

			foreach (System.Type currtype in ad.GetTypes() )
			{
				dt.Rows.Add(new object[] {currtype.Name, DBNull.Value,DBNull.Value});
				
				foreach(MemberInfo mi in currtype.GetMembers(BindingFlags.DeclaredOnly |
					BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Static | BindingFlags.Instance))
				{
					dt.Rows.Add(new object[] {DBNull.Value, mi.Name, mi.MemberType});
				}
			}

			grdResults.DataSource=dt;
			grdResults.DataBind();
		}

		private void btnLoadFull_Click(object sender, System.EventArgs e)
		{
			System.Reflection.Assembly ad =
			   System.Reflection.Assembly.Load(txtFullyQualifiedName.Text);
			
			WriteReport(ad);
		}

		private void btnLoadPartial_Click(object sender, System.EventArgs e)
		{
			System.Reflection.Assembly ad =
				System.Reflection.Assembly.LoadWithPartialName(txtPartiallyQualifiedName.Text);
			
			WriteReport(ad);
		}

		private void btnLoadFrom_Click(object sender, System.EventArgs e)
		{
			string path = MapPath(txtPath.Text);
			
			System.Reflection.Assembly ad =
				System.Reflection.Assembly.LoadFrom(path);
		
			WriteReport(ad);
		}


	}
}
