using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
//this code is needed for the sample code
//to work
using System.Collections;

namespace CodeControls
{
	[ToolboxData("<{0}:CodeGridWeb runat=server></{0}:CodeGridWeb>")]
	public class CodeGridWeb : System.Web.UI.WebControls.WebControl
	{
		private int _rows=10;
		private int _cols=5;
		Cell[,] _cells;
		Hashtable hsCells = new Hashtable();

		public class Cell
		{
			private string _text;
			CodeGridWeb _parent;
			private int _row, _col;
			string _key;
			
			public Cell(CodeGridWeb parent,
				int row, int col)
			{
				_parent = parent;
				_row = row;
				_col = col;
			}
			public string Text
			{
				get
				{
					return _text;
				}
				set
				{
					_text = value;
				}
			}
			public int Row
			{
				get
				{
					return _row;
				}
			}
			public int Column
			{
				get
				{
					return _col;
				}
			}

			public string Key
			{
				get
				{
					return _key;
				}
				set
				{
					_key = value;
					_parent.SetCellKey(_key,_row,_col);
				}
			}
		}


		public Cell this[int row, int col]
		{
			get
			{
				return _cells[row,col];
			}
		}

		public Cell this[string key]
		{
			get
			{
				Cell retVal = null;
				string cellIndex =
					(string)hsCells[key];
				if (cellIndex != null &&
					cellIndex != "")
				{
					string[ ] coords =
						cellIndex.Split(';');
					int r = System.Convert.
						ToInt32(coords[0]);
					int c = System.Convert.
						ToInt32(coords[1]);
					retVal = _cells[r,c];
				}
				return retVal;
			}
		}
		
		
		public void CreateGrid()
		{
			//allocate cells
			_cells = new Cell[_rows,_cols];
			for (int r = 0; r < _rows; r++)
				for(int c = 0; c < _cols; c++)
					_cells[r,c] = new Cell(this,r,c);
		}

		
		[Category("Appearance"),
		DefaultValue(10)]
		public int Rows
		{
			get
			{
				return _rows;
			}
			set
			{
				_rows = value;
				CreateGrid();
			}
		}
		
		
		[Category("Appearance"),
		DefaultValue(5)]
		public int Columns
		{
			get
			{
				return _cols;
			}
			set
			{
				_cols = value;
				CreateGrid();
			}
		}

		
		public CodeGridWeb() :
			base(HtmlTextWriterTag.Table)
		{
			CreateGrid();
		}
		
		
		private void SetCellKey(string key,
			int row, int col)
		{
			hsCells[key] = row.ToString() + ";" + col.ToString() + ";";
		}
		
		
		public string DrawGrid()
		{
			System.Text.StringBuilder sb = new
				System.Text.StringBuilder(1024);
			for (int r = 0; r < _rows; r++)
			{
				sb.Append("<tr>");
				for(int c = 0; c < _cols; c++)
				{
					sb.Append(@"<td STYLE=""border: 'thin black solid'"" WIDTH=50 HEIGHT=50>");
					sb.Append(_cells[r,c].Text);
					sb.Append("</td>");
				}
				sb.Append("</tr>");
			}
			return sb.ToString();
		}


		/// <summary>
		/// Render this control to the output parameter specified.
		/// </summary>
		/// <param name="output"> The HTML writer to write out to </param>
		protected override void Render
			(HtmlTextWriter output)
		{
			output.AddStyleAttribute(
				HtmlTextWriterStyle.BorderCollapse,"collapse");
			base.RenderBeginTag(output);
			output.Write(DrawGrid());
			base.RenderEndTag(output);
		}	
	}
}
