using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace classesandmembers
{
	class ToDoItem
	{
		//pola
		string item = "";
		string description = "";
      
		//waciwoci
		public string Item
		{
			get
			{
				return item;
			}
		}
      
		public string Description
		{
			get
			{
				return description;
			}
		}

		//metody      
		public void SetInfo(
			string item, string description)
		{
			this.item = item;
			this.description = description;
		}
	}
   
	class ToDoList
	{
		//pola
		Hashtable list = new Hashtable();
      
		//metody
		public void Add(ToDoItem tditem)
		{
			list.Add(tditem.Item,
				tditem.Description);
		}
      
		public void Remove(ToDoItem tditem)
		{
			list.Remove(tditem.Item);
		}

		public ICollection TaskList
		{
			get
			{
				return list.Values;
			}
		}

	}

	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class WebForm1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.HyperLink hypViewList;
		protected System.Web.UI.WebControls.TextBox txtItem;
		protected System.Web.UI.WebControls.Label lblToDo;
		protected System.Web.UI.WebControls.TextBox txtDescription;
		protected System.Web.UI.WebControls.Label lblItem;
		protected System.Web.UI.WebControls.Label lblDescription;
		protected System.Web.UI.WebControls.Label lblHelp;
		protected System.Web.UI.WebControls.Button btnTask;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnTask.Click += new System.EventHandler(this.btnTask_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		//Funkcja ClearFields czyci jedynie
                //zawarto pl tekstowych na formularzu.
                //Wywoujemy j po dodaniu zdania do listy.

		void ClearFields()
		{
			txtItem.Text = "";
			txtDescription.Text = "";
		}

		private void btnTask_Click(object sender, System.EventArgs e)
		{
			ToDoItem item = new ToDoItem();
			item.SetInfo(txtItem.Text, 
				txtDescription.Text);

			//Z globalnego obiektu Application pobierz
                        //obiekt ToDoList i dodaj do niego nowo
                        //utworzony obiekt ToDoItem. Nastpnie wyczy
                        //pola na formularzu.
                        //Do listy moe wpisywa zadania jednoczenie wielu
                        //uytkownikw, dlatego za pomoc funkcji Lock
                        //i Unlock zabezpieczamy aplikacj przed kolizjami
                        //poszczeglnych wtkw.
			Application.Lock();
			ToDoList list =
				(ToDoList)Application["list"];
			list.Add(item);
			Application.UnLock();
			ClearFields();
		}
	}
}
