using System;
using ordersInterfaces;
using System.Collections;

namespace ordersMemory
{
	public class OrderMgrMem : IOrderMgr
	{
		Hashtable hsOrders = new Hashtable();
		
		private class OrderKey
		{
			public string CustomerID="";
			public string InventoryID="";

			public OrderKey(string CustomerID,string InventoryID)
			{
				this.CustomerID = CustomerID;
				this.InventoryID = InventoryID;
			}

			public override bool Equals(object obj)
			{
				if ( !(obj is OrderKey) )
					return false;

				OrderKey temp = (OrderKey)obj;
				if (temp.CustomerID == CustomerID && temp.InventoryID == InventoryID)
					return true;

				return false;
			}

			public override int GetHashCode()
			{
				return ((string)(CustomerID + InventoryID)).GetHashCode();
			}
		}

		public OrderMgrMem()
		{
		}

		public int Count(string customerID)
		{
			Hashtable hsItems = (Hashtable)hsOrders[customerID];
			if (hsItems != null)
				return hsItems.Count;

			return 0;
		}

		public void EnterOrder(ICustomer customer, IInventory item, int qty)
		{
			Hashtable hsItems = (Hashtable)hsOrders[customer.ID];
			if (hsItems == null)
			{
				hsItems = new Hashtable();
				hsOrders[customer.ID]=hsItems;
			}

			IOrderItem _orderitem = (IOrderItem)hsItems[item.ID];
			if (_orderitem == null)
				_orderitem = new OrderItem();
			
			_orderitem.CustomerID = customer.ID;
			_orderitem.Description = item.Description;
			_orderitem.InventoryID = item.ID;
			_orderitem.Qty += qty;
			hsItems[item.ID]=_orderitem;
		}

		public IOrderItem this[string customerID, int Index]
		{
			get
			{
				Hashtable hsItems = (Hashtable)hsOrders[customerID];
				if (hsItems == null)
					return null;

				int counter=0;
				IOrderItem seeker=null;

				foreach(IOrderItem _orderitem in hsItems.Values)
				{
					if (counter == Index)
					{
						seeker = _orderitem;
						break;
					}
					counter++;
				}
				return seeker;
			}
		}

	}

}
