using System;

namespace ordersInterfaces
{
	//add the definition of the 
	//attribute here

	public interface ICustomer
	{
		string ID { get; set; }
		string Name { get; set; }
	}

	public interface ICustomerMgr
	{
		ICustomer this[string ID] { get; }
		ICustomer this[int Index] { get; }
		int Count { get; }
		ICustomer CreateNew();
		string AddCustomer(ICustomer customer);
		void RemoveCustomer(string ID);
	}


	public interface IInventory
	{
		string ID { get; set; }
		string Description { get; set; }
		int Qty {get; set;}
	}

	public interface IInventoryMgr
	{
		IInventory this[string ID] { get; }
		IInventory this[int Index] { get; }
		int Count { get; }
		void UpdateInventory(IInventory item);
	}

	
	public interface IOrderItem
	{
		string CustomerID {get; set;}
		string InventoryID {get; set;}
		string Description {get; set;}
		int Qty {get; set;}
	}

	public interface IOrderMgr
	{
		void EnterOrder(ICustomer customer, IInventory item, int qty);
		int Count(string customerID);
		IOrderItem this[string customerID, int Index] {get;}
	}
	
}
