using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ordersInterfaces;

namespace ordersystem
{
	/// <summary>
	/// Summary description for orders.
	/// </summary>
	public class orders : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.HyperLink lnkMenu;
		protected System.Web.UI.WebControls.DataGrid grdOrders;
		protected System.Web.UI.WebControls.DataGrid grdItems;
		protected System.Web.UI.WebControls.Label lblItems;
		protected System.Web.UI.WebControls.Label lblSummary;
		protected System.Web.UI.WebControls.Label lblTitle;
		string customerID;
		ICustomerMgr customers; 
		IInventoryMgr inventory;
		IOrderMgr orderlist; 
	
		void RefreshOrdersGrid()
		{
			int count = orderlist.Count(customerID);
			ArrayList list = new ArrayList();

			if (count > 0)
			{
				for (int index = 0; index < count; index++)
				{
					IOrderItem item = orderlist[customerID,index];
					list.Add(item);
				}
			}

			grdOrders.DataSource = list;
			grdOrders.DataBind();
		}

		void RefreshInventoryList()
		{
			int count = inventory.Count;
			ArrayList list = new ArrayList();

			if (count > 0)
			{
				for (int index = 0; index < count; index++)
				{
					IInventory item = inventory[index];
					list.Add(item);
				}
			}

			grdItems.DataSource = list;
			grdItems.DataBind();
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			customers = utilities.CreateCustomerManager(); //new ordersXML.CustomerMgrXML();
			inventory = utilities.CreateInventoryManager(); //new ordersXML.InventoryMgrXML();
			orderlist = utilities.CreateOrderManager();  //new ordersXML.OrderMgrXML();
			customerID = Request.QueryString["ID"];
			ICustomer customer = customers[customerID];
			lblTitle.Text = customer.Name;
			RefreshOrdersGrid();
			RefreshInventoryList();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.grdItems.UpdateCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.grdItems_UpdateCommand);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void grdItems_UpdateCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			int qty = System.Convert.ToInt32(Request.Form[e.Item.Cells[3].Controls[1].UniqueID]);
			string inventoryID = e.Item.Cells[0].Text;
			IInventory item = inventory[inventoryID];
			item.Qty -= qty;
			inventory.UpdateInventory(item);
			ICustomer customer = customers[customerID];
			orderlist.EnterOrder(customer,item,qty);
			RefreshInventoryList();
			RefreshOrdersGrid();
		}
	}
}
