using System;
using ordersInterfaces;
using System.Collections;

namespace ordersMemory
{
	public class InventoryMgrMem : IInventoryMgr
	{
		Hashtable hsItems = new Hashtable();
		ArrayList arrKeys = new ArrayList();

		public InventoryMgrMem()
		{
			IInventory item = new Inventory();
			item.ID="0BFBB791-2531-459d-829D-000000000001";
			item.Description="Computer Monitor";
			item.Qty=5;
			hsItems.Add(item.ID,item);
			arrKeys.Add(item.ID);
			item = new Inventory();
			item.ID="0BFBB791-2531-459d-829D-000000000002";
			item.Description="Thin Notebook";
			item.Qty=7;
			hsItems.Add(item.ID,item);
			arrKeys.Add(item.ID);
			item = new Inventory();
			item.ID="0BFBB791-2531-459d-829D-000000000003";
			item.Description="Wireless Mouse";
			item.Qty=15;
			hsItems.Add(item.ID,item);
			arrKeys.Add(item.ID);
		}

		public IInventory this[int Index]
		{
			get
			{
				string key = (string)arrKeys[Index];
				IInventory item = (IInventory)hsItems[key];
				return item;
			}
		}

		public IInventory this[string ID]
		{
			get
			{
				IInventory item = (IInventory)hsItems[ID];
				return item;
			}
		}

		public int Count
		{
			get
			{
				return arrKeys.Count;
			}
		}

		public void UpdateInventory(ordersInterfaces.IInventory item)
		{
			hsItems[item.ID] = item;		
		}

	}

}
