using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace loopsandconditionals
{
	class PurchasedItem
	{
		string name;
		int qty;
         
		public void SetInfo(string name, int qty)
		{
			this.name = name;
			this.qty = qty;
		}
         
		public string Name
		{
			get
			{
				return name;
			}
		}
         
		public int Quantity
		{
			get
			{
				return qty;
			}
		}
		
		public string Description
		{
			get
			{
				string desc="";
            
				switch(name)
				{
					case "Notebook":
						desc = "Malutki komputerek";
						break;
					case "Desktop":
						desc = "Wielki komputer";
						break;
					case "FlatMon":
						desc = 
							"Wspaniay paski monitorek";
						break;
					case "FatMon":
						desc = "Ciki wielki monitor";
						break;
					default:
						desc = "Towar nieznany";
						break;
				}
            
				return desc;
			}
		}

		public double Price
		{
			get
			{
				double price = 0.0;
            
				switch(name)
				{
					case "Notebook":
						price = 1999.99;
						break;
					case "Desktop":
						price = 899.00;
						break;
					case "FlatMon":
						price = 1500.00;
						break;
					case "FatMon":
						price = 300.00;
						break;
					default:
						price = 0.0;
						break;
				}
            
				return price;
			}
		}

	}
	
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class WebForm1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.TextBox txtQty;
		protected System.Web.UI.WebControls.Label lblItem;
		protected System.Web.UI.WebControls.Label lblQty;
		protected System.Web.UI.WebControls.Button btnAdd;
		protected System.Web.UI.WebControls.DropDownList lstItems;
		protected System.Web.UI.WebControls.DataGrid grdItems;
		protected System.Web.UI.WebControls.Label lblEmpty;
		protected System.Web.UI.WebControls.HyperLink lnkOrder;
	   
		ArrayList items;

		private void ShowGrid()
		{
			lblEmpty.Visible = false;
			grdItems.Visible = true;
		}
      
		private void HideGrid()
		{
			lblEmpty.Visible = true;
			grdItems.Visible = false;
		}

		private void UpdateGrid()
		{
			grdItems.DataSource = items;
			grdItems.DataBind();
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			if (Session["items"] == null)
			{
				items = new ArrayList();
				Session["items"] = items;
			}
			else
				items = (ArrayList)Session["items"];
  
			if (items.Count == 0)
				HideGrid();
			else
			{
				ShowGrid();
				UpdateGrid();
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			int qty = 0;

			if (txtQty.Text != null)
				qty = System.Convert.ToInt32
					(txtQty.Text);

			string name = lstItems.SelectedItem.
				Value;

			if (qty >= 0 && name != "")
			{
				PurchasedItem pi = 
					new PurchasedItem();
				pi.SetInfo(name,qty);
				items.Add(pi);
				ShowGrid();
				UpdateGrid();
			}

		}
	}
}
