<?php
App::import('Core', 'Security');

class UserShell extends Shell {
	public $uses = array('User');

	public function add() {
		$user = $this->in('Enter the username (ENTER to abort):');
		if (empty($user)) {
			$this->_stop();
		}

		$defaultPassword = $this->_randomPassword();;
		$password = $this->in('Enter the password (ENTER to use generated):', null, $defaultPassword);

		$this->out();
		$this->out('USER: '.$user);
		$this->out('PASSWORD: '.$password);
		$this->out();

		if (strtoupper($this->in('Proceed?', array('Y', 'N'), 'N')) != 'Y') {
			$this->_stop();
		}

		$user = array('User' => array(
			'username' => $user,
			'password' => Security::hash($password, null, true)
		));

		$this->User->create();
		if ($this->User->save($user)) {
			$this->out('User created.');
		} else {
			$this->error('Error while creating user.');
		}
	}

	public function help() {
		$this->out('USAGE: $ cake '.$this->shell.' <import <path/to/file> [-limit N | -size N | -verbose] | add>');
		$this->out('where:');
		$this->out();
		$this->out('-limit N: import up to N records');
		$this->out('-size N: size of generated password');
		$this->out('-verbose: Verbose output');
	}

	public function import() {
		$this->_checkArgs(1);

		$defaults = array(
			'limit' => null,
			'size' => 10,
			'verbose' => false
		);
		$options = array_merge(
			$defaults,
			array_intersect_key($this->params, $defaults)
		);

		$path = $this->args[0];
		if (!is_file($path) || !is_readable($path)) {
			$this->error('File '.$path.' cannot be read');
		}

		$users = array();
		foreach($this->_importCSV($path) as $i => $row) {
			$users[$row[0]] = $this->_randomPassword($options['size']);
			if (!empty($options['limit']) && $i + 1 == $options['limit']) {
				break;
			}
		}

		if ($options['verbose']) {
			$this->out('Will create '.number_format(count($users)).' accounts');
		}

		foreach($users as $userName => $password) {
			if ($options['verbose']) {
				$this->out('Creating user '.$userName.'... ', false);
			}

			$user = array('User' => array(
				'username' => $userName,
				'password' => Security::hash($password, null, true)
			));

			$this->User->create();
			$saved = ($this->User->save($user) !== false);
			if (!$saved) {
				unset($users[$userName]);
			}

			if ($options['verbose']) {
				$this->out($saved ? 'SUCCESS' : 'FAIL');
			}
		}


		$this->out('Created accounts:');
		foreach($users as $userName => $password) {
			$this->out($userName.' : '.$password);
		}
	}

	protected function _importCSV($path) {
		$file = fopen($path, 'r');
		if (!is_resource($file)) {
			$this->error('Can\'t open '.$file);
		}

		$rows = array();
		while($row = fgetcsv($file)) {
			$rows[] = $row;
		}

		fclose($file);
		return $rows;
	}

	protected function _randomPassword($size=10) {
		$chars = '@!#$_';
		foreach(array('A'=>'Z', 'a'=>'z', '0'=>'9') as $start => $end) {
			for ($i=ord($start), $limiti=ord($end); $i <= $limiti; $i++) {
				$chars .= chr($i);
			}
		}

		$totalChars = strlen($chars);
		$password = '';
		for($i=0; $i < $size; $i++) {
			$password .= $chars[rand(0, $totalChars-1)];
		}
		return $password;
	}
}
?>