<?php
class ArticlesControllerTestCase extends CakeTestCase {
	public $fixtures = array('app.article', 'app.user', 'app.vote');

	public function testView() {
		$result = $this->testAction('/articles/view/1', array('return'=>'vars'));
		$expected = array(
			'Article' => array(
				'id' => 1,
				'title' => 'Article 1',
				'body' => 'Body for Article 1'
			),
			0 => array(
				'vote' => 4.3333
			)
		);
		$this->assertTrue(!empty($result['article']));
		$this->assertEqual($result['article'], $expected);

		$result = $this->testAction('/articles/view/1', array('return'=>'view'));
		$this->assertTags($result, array(
			array('h1' => array()),
			'Article 1',
			'/h1',
			'Vote:',
			array('span' => array('id'=>'vote')),
			'4.3',
			'/span',
			array('p' => array()),
			'Body for Article 1',
			'/p'
		));
	}
}
?>
