<?php
class Article extends AppModel {
	public $hasMany = array('Vote');

	public function get($id) {
		return $this->find('first', array(
			'fields' => array(
				'Article.*',
				'AVG(Vote.vote) AS vote'
			),
			'joins' => array(
				array(
					'type' => 'LEFT',
					'table' => $this->Vote->getDataSource()->fullTableName($this->Vote->table),
					'alias' => 'Vote',
					'conditions' => array(
						'Vote.article_id = Article.id'
					)
				)
			),
			'conditions' => array('Article.id' => $id),
			'group' => array(
				'Article.id'
			),
			'recursive' => -1
		));
	}

	public function vote($id, $data = array()) {
		if (empty($data) || empty($data['Vote'])) {
			throw new Exception("No data specified");
		}

		$data['Vote']['article_id'] = $id;

		$this->Vote->create($data);
		if (!$this->Vote->validates()) {
			return false;
		}

		$conditions = array(
			'Vote.user_id' => $data['Vote']['user_id'],
			'Vote.article_id' => $data['Vote']['article_id']
		);
		if ($this->Vote->hasAny($conditions)) {
			return false;
		}

		return ($this->Vote->save($data) !== false);
	}
}
?>