CREATE TABLE `users`(
	`id` INT NOT NULL AUTO_INCREMENT,
	`name` VARCHAR(255) NOT NULL,
	`email` VARCHAR(255) NOT NULL,
	PRIMARY KEY(`id`)
);

CREATE TABLE `blogs`(
	`id` INT NOT NULL AUTO_INCREMENT,
	`user_id` INT NOT NULL,
	`name` VARCHAR(255) NOT NULL,
	PRIMARY KEY(`id`),
	KEY `user_id`(`user_id`),
	CONSTRAINT `blogs__users` FOREIGN KEY(`user_id`) REFERENCES `users`(`id`)
);

CREATE TABLE `posts`(
	`id` INT NOT NULL AUTO_INCREMENT,
	`blog_id` INT NOT NULL,
	`title` VARCHAR(255) NOT NULL,
	`body` TEXT NOT NULL,
	`created` DATETIME NOT NULL,
	`modified` DATETIME NOT NULL,
	PRIMARY KEY(`id`),
	KEY `blog_id`(`blog_id`),
	CONSTRAINT `posts__blogs` FOREIGN KEY(`blog_id`) REFERENCES `blogs`(`id`)
);

INSERT INTO `users`(`id`, `name`, `email`) VALUES
	(1, 'John Doe', 'john.doe@example.com'),
	(2, 'Jane Doe', 'jane.doe@example.com');

INSERT INTO `blogs`(`user_id`, `name`) VALUES
	(1, 'John Doe\'s Blog'),
	(2, 'Jane Doe\'s Blog');

INSERT INTO `posts`(`blog_id`, `title`, `body`, `created`, `modified`) VALUES
	(1, 'John\'s Post 1', 'Body for John\'s Post 1', '2010-04-19 14:00:00', '2010-04-19 14:00:00'),
	(1, 'John\'s Post 2', 'Body for John\'s Post 2', '2010-04-19 14:30:00', '2010-04-19 14:30:00'),
	(1, 'John\'s Post 3', 'Body for John\'s Post 3', '2010-04-20 14:00:00', '2010-04-20 14:00:00'),
	(1, 'John\'s Post 4', 'Body for John\'s Post 4', '2010-05-03 14:00:00', '2010-05-03 14:00:00'),
	(2, 'Jane\'s Post 1', 'Body for Jane\'s Post 1', '2010-04-19 15:00:00', '2010-04-19 15:00:00'),
	(2, 'Jane\'s Post 2', 'Body for Jane\'s Post 2', '2010-06-18 15:00:00', '2010-06-18 15:00:00'),
	(2, 'Jane\'s Post 3', 'Body for Jane\'s Post 3', '2010-10-06 15:00:00', '2010-10-06 15:00:00');