<?php
class ProfilesController extends AppController {
	public function beforeFilter() {
		parent::beforeFilter();
		$prefixes = Configure::read('Routing.prefixes');
		if (!empty($prefixes)) {
			foreach($prefixes as $prefix) {
				$hasPrefix = false;
				if (!empty($this->params['prefix'])) {
					$hasPrefix = ($this->params['prefix'] == $prefix);
				}
				$prefixName = 'is' . Inflector::classify($prefix);
				$this->$prefixName = $hasPrefix;
				$this->set($prefixName, $hasPrefix);
			}
		}
	}

	public function manager_index() {
		$this->setAction('index');
	}

	public function manager_edit($id) {
		$this->setAction('edit', $id);
	}

	public function admin_index() {
		$this->setAction('index');
	}

	public function admin_edit($id) {
		$this->setAction('edit', $id);
	}

	public function admin_add() {
		$this->setAction('edit');
	}

	public function index() {
		$profiles = $this->paginate();
		$this->set(compact('profiles'));
	}

	public function edit($id = null) {
		if (!empty($id) && !$this->isAdmin && !$this->isManager) {
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) {
			if (empty($id)) {
				$this->Profile->create();
			}
			if ($this->Profile->save($this->data)) {
				$this->Session->setFlash('Profile saved');
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash('Please correct the errors');
			}
		} elseif (!empty($id)) {
			$this->data = $this->Profile->find('first', array(
				'conditions' => array('Profile.id' => $id),
				'recursive' => -1
			));
		}
	}
}
?>
