<?php
class TweetsController extends AppController {
	public function beforeFilter() {
		parent::beforeFilter();
		if (!$this->_authorize()) {
			$this->redirect(null, 403);
		}
	}

	protected function _authorize() {
		$authorize = $this->Session->read('authorize');
		if (empty($authorize)) {
			$source = $this->Tweet->getDataSource();
			$url = Router::url(null, true);
			if (
				!empty($this->params['url']['oauth_token']) &&
				!empty($this->params['url']['oauth_verifier'])
			) {
				$authorize = $source->authorize(
					$this->params['url']['oauth_token'],
					$this->params['url']['oauth_verifier']
				);
				$this->Session->write('authorize', $authorize);
			} elseif (!empty($this->params['url']['denied'])) {
				return false;
			} else {
				$token = $source->token($url);
				$this->redirect('http://api.twitter.com/oauth/authorize?oauth_token=' . $token);
			}
		}

		if (!empty($authorize)) {
			$this->Tweet->getDataSource()->setConfig(compact('authorize'));
		}
		return $authorize;
	}
	
	public function index($twitter) {
		$tweets = $this->Tweet->find('all', array(
			'conditions' => array('username' => $twitter)
		));
		$this->set(compact('tweets', 'twitter'));
	}

	public function add($twitter) {
		if (!empty($this->data)) {
			$this->Tweet->create();
			if ($this->Tweet->save($this->data)) {
				$this->Session->setFlash('Succeeded');
			} else {
				$this->Session->setFlash('Failed');
			}
		}
		$this->redirect(array('action'=>'index', $twitter));
	}
}
?>