<?php
if (empty($queryLog)) {
	echo $this->element('sql_dump');
	return;
}

foreach($queryLog as $datasource => $log) {
?>
	<table class="cake-sql-log">
	<caption>
		Datasource <strong><?php echo $datasource; ?></strong>:
		<?php echo number_format($log['count']) . ' queries (' . $log['time'] . ' ms. total time)'; ?>
	</caption>
	<thead><tr>
		<th>Query</th>
		<th>Error</th>
		<th>Affected</th>
		<th>Num. rows</th>
		<th>Took</th>
	</tr></thead>
	<tbody>
		<?php foreach($log['log'] as $line) { ?>
		<tr>
			<td>
			<?php echo $line['query']; ?>
			<?php if (!empty($line['explain'])) { ?>
				<br /><br />
				<table class="cake-sql-log-explain">
				<thead><tr>
					<th>ID</th>
					<th>Select Type</th>
					<th>Table</th>
					<th>Type</th>
					<th>Possible Keys</th>
					<th>Key</th>
					<th>Ref</th>
					<th>Rows</th>
					<th>Extra</th>
				</tr></thead>
				<tbody>
				<?php foreach($line['explain'] as $explainLine) { ?>
					<tr>
					<td><?php echo $explainLine['id']; ?></td>
					<td><?php echo $explainLine['select_type']; ?></td>
					<td><?php echo $explainLine['table']; ?></td>
					<td><?php echo $explainLine['type']; ?></td>
					<td><?php echo $explainLine['possible_keys']; ?></td>
					<td><?php
					echo $explainLine['key'];
					if (!empty($explainLine['key_len'])) {
						echo ' (' . number_format($explainLine['key_len']) . ' )';
					}
					?></td>
					<td><?php echo $explainLine['ref']; ?></td>
					<td><?php echo number_format($explainLine['rows']); ?></td>
					<td><?php echo $explainLine['extra']; ?></td>
					</tr>
				<?php } ?>
				</tbody>
				</table>
			<?php } ?>
			</td>
			<td><?php echo $line['error']; ?></td>
			<td><?php echo number_format($line['affected']); ?></td>
			<td><?php echo number_format($line['numRows']); ?></td>
			<td><?php echo number_format($line['took']) . ' ms.'; ?></td>
		</tr>
		<?php } ?>
	</tbody>
	</table>
<?php } ?>