<?php
class UsersController extends AppController {
	public function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('add');
	}

	public function add() {
		if (!empty($this->data)) {
			$this->User->create();
			if ($this->User->save($this->data)) {
				$this->Session->setFlash('User created!');
				$this->redirect(array('action'=>'login'));
			} else {
				$this->Session->setFlash('Please correct the errors');
			}
		}
	}

	public function login() {
	}

	public function logout() {
		$this->redirect($this->Auth->logout());
	}

	public function token() {
		$token = sha1(String::uuid());
		$this->User->id = $this->Auth->user('id');
		if (!$this->User->saveField('token', $token)) {
			$token = null;
			$this->Session->setFlash('There was an error generating this token');
		}
		$this->set(compact('token'));
	}
}
?>