<?php
class Profile extends AppModel {
   public $validate = array(
      'email' => array('rule' => 'notEmpty'),
      'name' => array('rule' => 'notEmpty'),
      'twitter' => array(
      'rule' => 'validateTwitter',
      'allowEmpty' => true,
      'message' => 'To konto nie istnieje w serwisie Twitter'
      )
   );
   protected static $httpSocket;
   protected function validateTwitter($data) {
      if (!isset(self::$httpSocket)) {
         App::import('Core', 'HttpSocket');
         self::$httpSocket = new HttpSocket();
      }
      $value = current($data);
      self::$httpSocket->get('http://twitter.com/status/user_
timeline/' . $value . '.json?count=1');
      return (self::$httpSocket->response['status']['code'] != 401);
   }
}

?>
