//************************  trie.cpp  *********************************

#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include "trie.h"

TrieLeafNode::TrieLeafNode(char *suffix) {
    leaf = true;
    word = new char[strlen(suffix)+1];
    if (word == 0) {
        cerr << "Brak pamici2.\n";
        exit(-1);
    }
    strcpy(word,suffix);
}

TrieNonLeafNode::TrieNonLeafNode(char ch) {
    ptrs = new TrieNonLeafNode*;
    letters = new char[2];
    if (ptrs == 0 || letters == 0) {
        cerr << "Brak pamici3.\n";
        exit(1);
    }
    leaf = false;
    endOfWord = false;
    *ptrs = 0;
    *letters = ch;
    *(letters+1) = '\0';
}

Trie::Trie(char* word) : notFound(-1) {
    root = new TrieNonLeafNode(*word); // inicjalizacja kozenia
    createLeaf(*word,word+1,root); // aby unikn pniejszych sprawdze
}

void Trie::sideView(int depth, TrieNonLeafNode *p, char *prefix) {
    register int i;             // zaoenie: korze nie jest liciem
    if (p->leaf) {              // i nie jest pusty (null)
         TrieLeafNode *lf = (TrieLeafNode*) p;
         for (i = 1; i <= depth; i++)
             cout << "   ";
         cout << " >>" << prefix << "|" << lf->word << endl;
    }
    else {
         for (i = strlen(p->letters)-1; i >= 0; i--)
             if (p->ptrs[i] != 0) {             // dodaj liter odpowiadajc
                 prefix[depth] = p->letters[i]; // pozycji i do przedrostka
                 prefix[depth+1] = '\0';
                 sideView(depth+1,p->ptrs[i],prefix);
             }
         if (p->endOfWord) {
              prefix[depth] = '\0';
              for (i = 1; i <= depth+1; i++)
                  cout << "   ";
              cout << ">>>" << prefix << "|\n";
         }
    }
}

int Trie::position(TrieNonLeafNode *p, char ch) {
    int i;
    for (i = 0; i < strlen(p->letters) && p->letters[i] != ch; i++);
    if (i < strlen(p->letters))
         return i;
    else return notFound;
}

bool Trie::wordFound(char *word) {
    TrieNonLeafNode *p = root;
    TrieLeafNode *lf;
    int pos;
    while (true)
        if (p->leaf) {                      // wze p jest liciem
            lf = (TrieLeafNode*) p;         // gdzie naley szuka
            if (strcmp(word,lf->word) == 0) // kocwki sowa
                 return true;
            else return false;
        }
        else if (*word == '\0')             // koniec sowa musi odpowiada
             if (p->endOfWord)              // znacznikowi endOfWord 
                  return true;
             else return false;             // w wle p ustawione na true
        else if ((pos = position(p,*word)) != notFound &&
                 p->ptrs[pos] != 0) {       // podaj t ciek dalej,
             p = p->ptrs[pos];              // jeli mona;
             word++;
        }
        else return false;                  // jeli nie, niepowodzenie
}

void Trie::addCell(char ch, TrieNonLeafNode *p, int stop) {
    int i, len = strlen(p->letters);
    char *s = p->letters;
    TrieNonLeafNode **tmp = p->ptrs;
    p->letters = new char[len+2];
    p->ptrs    = new TrieNonLeafNode*[len+1];
    if (p->letters == 0 || p->ptrs == 0) {
        cerr << "Brak pamici1.\n";
        exit(1);
    }
    for (i = 0; i < len+1; i++)
        p->ptrs[i] = 0;
    if (stop < len)                // jeli ch nie znajduja si za literami p,
         for (i = len; i >= stop+1; i--) { // skopiuj litery tmp > ch
             p->ptrs[i]    = tmp[i-1];
             p->letters[i] = s[i-1];
         }
    p->letters[stop] = ch;
    for (i = stop-1; i >= 0; i--) {           // i litery < ch;
        p->ptrs[i]    = tmp[i];
        p->letters[i] = s[i];
    }
    p->letters[len+1] = '\0';
    delete [] s;
}

void Trie::createLeaf(char ch, char *suffix, TrieNonLeafNode *p) {
    int pos = position(p,ch);
    if (pos == notFound) {
        for (pos = 0; pos < strlen(p->letters) &&
                      p->letters[pos] < ch; pos++);
        addCell(ch,p,pos);
    }
    p->ptrs[pos] = (TrieNonLeafNode*) new TrieLeafNode(suffix);
}

void Trie::insert(char *word) {
    TrieNonLeafNode *p = root;
    TrieLeafNode *lf;
    int offset, pos;
    char *hold = word;
    while (true) {
        if (*word == '\0') {            // jeli znaleziono koniec sowa
             if (p->endOfWord)
                  cout << "Duplikat hasa1 " << hold << endl;
             else p->endOfWord = true;  // ustaw endOfWord na true;
             return;
        }                               // jei pozycja p wskazywna 
        pos = position(p,*word);
        if (pos == notFound) {          // przez pierwsz liter sowa
             createLeaf(*word,word+1,p);// nie istnieje, utwrz li
             return;                    // i zapisz w nim nieanalizowan
        }                               // kocwk sowa
        else if (pos != notFound &&     // jeli poeenie *word zajte
                 p->ptrs[pos]->leaf) {  // jest przez li, zostaw ten
             lf = (TrieLeafNode*) p->ptrs[pos];    // li
             if (strcmp(lf->word,word+1) == 0) {
                 cout << "Duplikat hasa2 " << hold << endl;
                 return;
             }
             offset = 0;
             // utwrz tyle wzw nie-lici, jaka jest dugo identycznego
             // przedrostka sowa i acucha z licia (dla komrki "R",
             // licia "EP" i sowa "REAR" utworzone zostan dwa takie wzy)
             do {
                 pos = position(p,word[offset]);
                 // word == "ABC", leaf = "ABCDEF" => leaf = "DEF";
                 if (strlen(word) == offset+1) {
                      p->ptrs[pos] = new TrieNonLeafNode(word[offset]);
                      p->ptrs[pos]->endOfWord = true;
                      createLeaf(lf->word[offset],lf->word + offset+1,p->ptrs[pos]);
                      return;
                 }
                 // word == "ABCDE", leaf = "ABC" => leaf = "DEF";
                 else if (strlen(lf->word) == offset) {
                      p->ptrs[pos] = new TrieNonLeafNode(word[offset+1]);
                      p->ptrs[pos]->endOfWord = true;
                      createLeaf(word[offset+1],word+offset+2,p->ptrs[pos]);
                      return;
                 }
                 p->ptrs[pos] = new TrieNonLeafNode(word[offset+1]);
                 p = p->ptrs[pos];
                 offset++;
             } while (word[offset] == lf->word[offset-1]);
             offset--;
             // word = "ABCDEF", leaf = "ABCPQR" =>
             //    leaf('D') = "EF", leaf('P') = "QR";
             // sprawd, czy zostaa jeszcze kocwka
             // word = "ABCD", leaf = "ABCPQR" =>
             //    leaf('D') = null, leaf('P') = "QR";
             char *s = "";
             if (strlen(word) > offset+2)
                  s = word+offset+2;
             createLeaf(word[offset+1],s,p);
             // sprawd, czy zostaa jeszcze kocwka
             // word = "ABCDEF", leaf = "ABCP" =>
             //    leaf('D') = "EF", leaf('P') = null;
             if (strlen(lf->word) > offset+1)
                  s = lf->word+offset+1;
             else s = "";
             createLeaf(lf->word[offset],s,p);
             delete [] lf->word;
             delete lf;
             return;
        }
        else {
             p = p->ptrs[pos];
             word++;
        }
    }
}

