//************************  spellCheck.cpp ****************************

#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "trie.h"

char* strupr(char *s) {
    char *ss;
    for (ss = s; *s = toupper(*s); s++);
    return ss;
}

int main(int argc, char* argv[])  {
    char fileName[25], s[80], ch;
    int i, lineNum = 1;
    ifstream dictionary("slownik");
    if (dictionary.fail()) {
       cerr << "Nie mona otworzy sownika 'slownik'\n";
       exit(-1);
    }
    dictionary >> s;
    Trie trie(strupr(s));   // inicjalizuj korze
    while (dictionary >> s) // inicjalizuj drzewo sownikowe
        trie.insert(strupr(s));
    cout << " PRZEGLD:\n"; trie.sideView();
    if (argc != 2) {
         cout << "Podaj nazw pliku: ";
         cin  >> fileName;
    }
    else strcpy(fileName,argv[1]);
    ifstream textFile(fileName);
    if (textFile.fail()) {
       cerr << "Nie mona otworzy " << fileName << endl;
       exit(-1);
    }
    cout << "Bdnie zapisane sowa:\n";
    textFile.get(ch);
    while (!textFile.eof()) {
        while (true)
             if (!textFile.eof() && !isalpha(ch)) { // pomi nielitery
                  if (ch == '\n')
                        lineNum++;
                  textFile.get(ch);
             }
             else break;
        if (textFile.eof())       // spacje na kocu pliku textFile
             break;
        for (i = 0; !textFile.eof() && isalpha(ch); i++) {
             s[i] = toupper(ch);
             textFile.get(ch);
        }
        s[i] = '\0';
        if (!trie.wordFound(s))
             cout << s << " w wierszu " << lineNum << endl;
    }
    dictionary.close();
    textFile.close();
    return 0;
}
