<Query Kind="Program">
  <Namespace>System.Collections.Concurrent</Namespace>
</Query>

string filename = "tempref.tmp";

void Main()
{
	// Utworzenie i otwarcie pliku, aby nie dało się go usunąć
	var writer = File.CreateText(filename);
	
	// Czasowa referencja w osobnej metodzie.
	// Po zwrocie zmienna wyjdzie poza zakres dostępności i będzie gotowa do usunięcia przez system usuwania nieużytków.
	CreateTempFileRef();
	
	GC.Collect(); // uruchomieni systemu usuwania nieużytków
	
	TempFileRef._failedDeletions.Dump();
}

void CreateTempFileRef()
{
	var tempRef = new TempFileRef(filename); 
	
}

public class TempFileRef
{
	static internal ConcurrentQueue<TempFileRef> _failedDeletions
		= new ConcurrentQueue<TempFileRef>();

	public readonly string FilePath;
	public Exception DeletionError { get; private set; }

	public TempFileRef (string filePath) { FilePath = filePath; }

	// int _deleteAttempt; // usuń komentarz, jeśli chcesz ponownie zarejestrować finalizator
	
	~TempFileRef()
	{
		try { File.Delete (FilePath); }
		catch (Exception ex)
		{
			DeletionError = ex;
			_failedDeletions.Enqueue (this);   // wskrzeszenie
			// usuń poniższy komentarz, aby ponownie zarejestrować do finalizacji:
			// if (_deleteAttempt++ < 3) GC.ReRegisterForFinalize (this);
		}
	}
}