﻿// WAŻNA UWAGA: Ten plik nie jest kompilowany

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter12.Listing12_45
{
    // BŁĄD: nieprawidłowa wariancja. Określający typ parametr 'T'
    // nie jest poprawny ze względu na wariancję.

    interface IPairInitializer<in T>
    {
        void Initialize(IPair<T> pair);
    }

    // Załóżmy, że przedstawiony wyżej kod jest poprawny. 
    // Zobacz, jakie problemy mogą wystąpić.

    // ...

    class FruitPairInitializer : IPairInitializer<Fruit>
    {
        // Kod inicjuje parę obiektów typu Fruit
        // wartościami typów Orange i Apple.
        public void Initialize(IPair<Fruit> pair)
        {
            pair.First = new Orange();
            pair.Second = new Apple();
        }
    }

    // Dalej w kodzie.

    public class Program
    {
        public static void Main()
        {
            var f = new FruitPairInitializer();

            // Gdyby kontrawariancja była tu dozwolona, ten kod byłby poprawny:
            IPairInitializer<Apple> a = f;

            // Poniższy kod zapisuje obiekt typu Orange w obiekcie z parą obiektów typu Apple.
            a.Initialize(new Pair<Apple>());
        }
    }
}