﻿using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_25.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void Main_HappyPath()
        {
            string expected = @"Wprowadź imię: <<Inigo
>>Wprowadź wiek: <<42
>>Hej, Inigo! Twój wiek w miesiącach to 504.
Żegnaj, Inigo!";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(expected,
            () =>
            {
                ExceptionHandling.Main();
            });
        }

        [TestMethod]
        public void Main_GivenInvalidAge_ThrowException()
        {
            string expected = @"Wprowadź imię: <<Inigo
>>Wprowadź wiek: <<forty-two
>>Wprowadzony wiek, forty-two, jest nieprawidłowy.
Żegnaj, Inigo!";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(expected,
            () =>
            {
                ExceptionHandling.Main();
            });
        }
    }
}