﻿// Wyjaśnienie - tylko częściowa implementacja przedstawiona w celach edukacyjnych
#pragma warning disable IDE0059 // Niepotrzebne przypisanie wartości

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter08.Listing08_05
{
    using System;
    using Listing08_02;

    public class Program
    {
        public static void Main()
        {
            string?[] values;
            Contact contact = new Contact("Inigo Montoya");

            // ...

            // BŁĄD: nie można wywołać właściwości CellValues() bezpośrednio
            //           dla obiektu contact.
            // values = contact.CellValues;

            // Rzutowanie na typ IListable
            values = ((IListable)contact).CellValues;
            // ...

        }
    }

    public class Contact : PdaItem, IListable, IComparable
    {
        // ...
        public Contact(string name)
            : base(name)
        {
        }

        #region Składowe interfejsu IComparable
        /// <summary>
        /// 
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>
        /// Mniej niż zero — dana instancja ma wartość mniejszą niż obj. 
        /// Zero — dana instancja ma wartość równą obj.
        /// Więcej niż zero — dana instancja ma wartość większą niż obj. 
        /// </returns>
        public int CompareTo(object? obj) => obj switch
        {
            null => 1,
            Contact contact when ReferenceEquals(this, obj) => 0,
            Contact { LastName: string lastName }
                when LastName.CompareTo(lastName) != 0 =>
                    LastName.CompareTo(lastName),
            Contact { FirstName: string firstName }
                when FirstName.CompareTo(firstName) != 0 =>
                    FirstName.CompareTo(firstName),
            Contact _ => 0,
            _ => throw new ArgumentException(
                $"Parametr nie jest wartością typu { nameof(Contact) }",
                nameof(obj))
        };
        #endregion

        #region Składowe interfejsu IListable
        string?[] IListable.CellValues
        {
            get
            {
                return new string?[] 
                {
                    FirstName,
                    LastName,
                    Phone,
                    Address
                };
            }
        }
        #endregion

        private string? _LastName;
        protected string LastName
        {
            get => _LastName!;
            set => _LastName = value ?? throw new ArgumentNullException(nameof(value));
        }

        private string? _FirstName;
        protected string FirstName
        {
            get => _FirstName!;
            set => _FirstName = value ?? throw new ArgumentNullException(nameof(value));
        }
        protected string? Phone { get; set; }
        protected string? Address { get; set; }
        static public string GetName(string firstName, string lastName)
            => $"{ firstName } { lastName }";
    }
}