static void Receive()
{
  using (TcpClient client = new TcpClient ("mail.isp.com ", 110))
  using (NetworkStream n = client.GetStream())
  {
    ReadLine (n);                             // Odczyt komunikatu powitalnego.
    SendCommand (n, "USER username");
    SendCommand (n, "PASS password");
    SendCommand (n, "LIST");                  // Pobranie identyfikatorów wiadomości.
    List<int> messageIDs = new List<int>();
    while (true)
    {
      string line = ReadLine (n);             // Na przykład "1 1876".
      if (line == ".") break;
      messageIDs.Add (int.Parse (line.Split (' ')[0] ));   // Identyfikator wiadomości.
    }

    foreach (int id in messageIDs)         // Pobranie wszystkich wiadomości.
    {
      SendCommand (n, "RETR " + id);
      string randomFile = Guid.NewGuid().ToString() + ".eml";
      using (StreamWriter writer = File.CreateText (randomFile))
        while (true)
        {
          string line = ReadLine (n);      // Odczyt kolejnego wiersza wiadomości.
          if (line == ".") break;          // Pojedyncza kropka oznacza koniec wiadomości.
          if (line == "..") line = ".";    // "Obsługa" dwóch kropek.
          writer.WriteLine (line);         // Zapis danych w pliku docelowym.
        }
      SendCommand (n, "DELE " + id);       // Usunięcie wiadomości z serwera.
    }
    SendCommand (n, "QUIT");
  }
}

static string ReadLine (Stream s)
{
  List<byte> lineBuffer = new List<byte>();
  while (true)
  {
    int b = s.ReadByte();
    if (b == 10 || b < 0) break;
    if (b != 13) lineBuffer.Add ((byte)b);
  }
  return Encoding.UTF8.GetString (lineBuffer.ToArray());
}

static void SendCommand (Stream stream, string line)
{
  byte[] data = Encoding.UTF8.GetBytes (line + "\r\n");
  stream.Write (data, 0, data.Length);
  string response = ReadLine (stream);
  if (!response.StartsWith ("+OK"))
    throw new Exception ("Błąd POP: " + response);
}