// Usunięcie domyślnego egzemplarza nasłuchującego.
Trace.Listeners.Clear();

// Dodanie egzemplarza, który dołącza dane do pliku trace.txt.
Trace.Listeners.Add (new TextWriterTraceListener ("trace.txt"));

// Pobranie strumienia danych wyjściowych konsoli, a następnie dodanie go jako egzemplarza nasłuchującego.
System.IO.TextWriter tw = Console.Out;
Trace.Listeners.Add (new TextWriterTraceListener (tw));

// Konfiguracja dziennika zdarzeń Windows jako źródła, a następnie utworzenie lub dodanie egzemplarza nasłuchującego.
// Metoda CreateEventSource() wymaga uprawnień administratora, więc te wiersze kodu
// zwykle będą się znajdowały w konfiguracji aplikacji.
if (!EventLog.SourceExists ("DemoApp"))
  EventLog.CreateEventSource ("DemoApp", "Application");

Trace.Listeners.Add (new EventLogTraceListener ("DemoApp"));