﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter10.Listing10_12.Tests
{
    [TestClass]
    public class TextNumberParserTests
    {
        [TestMethod]
        public void Main_InigoMontoya_Success()
        {
            const string expected =
                @"Witaj, Inigo Montoya.";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, (Action<string[]>)(Program.Main), "Inigo Montoya" );
        }
        [TestMethod]
        public void Main_InigoMontoyaWithGreeting_Success()
        {
            const string expected =
                @"Witaj, Inigo Montoya. Dobrego dnia!";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, (Action<string[]>)(Program.Main), "Inigo Montoya", "-g", "Witaj, {name}. Dobrego dnia!");
        }

        [TestMethod]
        public void Main_GreetingWithInigoMontoya_Success()
        {
            const string expected =
                @"Witaj, Inigo Montoya. Dobrego dnia!";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, (Action<string[]>)(Program.Main), "-g", "Witaj, {name}. Dobrego dnia!", "Inigo Montoya");
        }

        [TestMethod]
        public void Main_OptionQuestionMark_Success()
        {
            const string expected =
                @"

Usage:  [arguments] [options]

Arguments:
  name  Podaj imię i nazwisko pozdrawianej osoby.

Options:
  -$|-g |--greeting <pozdrowienie>  Wyświetlane pozdrowienie. Używany jest tu łańcuch znaków formatowania, gdzie człon '{name}' jest zastępowany imieniem i nazwiskiem.
  -? | -h | --help              Show help information

Witaj, .";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, (Action<string[]>)(Program.Main), "-?");
        }
    }
}