﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_33
{
    using System;
    using System.IO;

    public class Program
    {
        public static void Main()
        {
            System.Console.WriteLine("Brak danych wyjściowych w tym przykładzie");
        }
    }

    class Employee
    {
        public Employee(string firstName, string lastName)
        {
            int id;
            // Generowanie identyfikatora pracownika.
            id = 0; // W tym przykładzie trzeba zainicjować zmienną id.
            // ...
            Initialize(id, firstName, lastName);
        }

        public Employee(int id, string firstName, string lastName)
        {
            Initialize(id, firstName, lastName);
        }

        public Employee(int id)
        {
            string firstName;
            string lastName;
            Id = id;

            // Wyszukiwanie danych pracownika.
            firstName = string.Empty;
            lastName = string.Empty;
            // ...

            Initialize(id, firstName, lastName);
        }

        private void Initialize(
            int id, string firstName, string lastName)
        {
            Id = id;
            FirstName = firstName;
            LastName = lastName;
        }
        // ...


        public int Id { get; private set; }
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string Salary { get; set; } = "Za niskie";
        public string Title { get; set; }
        public Employee Manager { get; set; }

        // Właściwość Name.
        public string Name
        {
            get
            {
                return FirstName + " " + LastName;
            }
            set
            {
                // Podział przypisanej wartości 
                // na imię i nazwisko.
                string[] names;
                names = value.Split(new char[] { ' ' });
                if(names.Length == 2)
                {
                    FirstName = names[0];
                    LastName = names[1];
                }
                else
                {
                    // Zgłaszanie wyjątku, jeśli
                    // nie przypisano imienia i nazwiska.
                    throw new System.ArgumentException(
                        $"Przypisana wartość '{value}' jest nieprawidłowa");
                }
            }
        }
    }
}
