﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_41.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void MainTest_ArgsHasZeroElements_ThrowException()
        {
            Assert.ThrowsException<ArgumentException>(
                () => Program.Main(new string[] { }));
        }

        [TestMethod]
        public void MainTest()
        {
            const string expected = @"Długość najdłuższego argumentu = 10
Długość najkrótszego argumentu = 2";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(expected, () =>
                {
                    Program.Main(
                        new string[] {
                            "C#", "C++", "Java", "JavaScript", "COBOL" });
                });
        }
    }
}