namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_16
{
    using System;

    public class Program
    {
        // Zwracanie referencji.
        public static ref byte FindFirstRedEyePixel(byte[] image)
        {
            // Zaawansowane wykrywanie cech obrazu, moliwe, e z uyciem uczenia maszynowego.
            for (int counter = 0; counter < image.Length; counter++)
            {
                if (image[counter] == (byte)ConsoleColor.Red)
                {
                    return ref image[counter];
                }
            }
            throw new InvalidOperationException("Nie wystpuj czerwone piksele.");
        }
        public static void Main()
        {
            byte[] image = new byte[254];
            // Wczytywanie obrazu.
            int index = new Random().Next(0, image.Length - 1);
            image[index] =
              (byte)ConsoleColor.Red;
            System.Console.WriteLine(
              $"image[{index}]={(ConsoleColor)image[index]}");
            // ...

            // Pobieranie referencji do pierwszego czerwonego piksela.
            ref byte redPixel = ref FindFirstRedEyePixel(image);
            // Zmienianie koloru na czarny.
            redPixel = (byte)ConsoleColor.Black;
            System.Console.WriteLine((ConsoleColor)image[redPixel]);
        }
    }
}
