﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter09.Listing09_16
{
    using System;
    using System.IO;
    using System.Runtime.InteropServices;

    public class Program
    {
        public static void Main()
        {
            // ...
            string fileName = @"enumtest.txt";
            System.IO.FileInfo enumFile =
                new System.IO.FileInfo(fileName);
            if (!enumFile.Exists)
            {
                enumFile.Create().Dispose();
            }

            try
            {
                System.IO.FileInfo file =
                    new System.IO.FileInfo(fileName);

                file.Attributes = FileAttributes.Hidden |
                    FileAttributes.ReadOnly;

                Console.WriteLine($"{file.Attributes} = {(int)file.Attributes}");

                // W Linksie działa tylko atrybut ReadOnly (Hidden nie jest obsługiwany Linux).
                if (!System.Runtime.InteropServices.RuntimeInformation.IsOSPlatform(OSPlatform.Linux))
                {
                    // Dodane w C# 4.0 i platformie Microsoft .NET Framework 4.0.
                    if (!file.Attributes.HasFlag(FileAttributes.Hidden))
                    {
                        throw new Exception("Plik nie jest ukryty.");
                    }
                }
                    // W wersjach starszych niż C# 4.0 i .NET 4.0 należy używać operatorów bitowych.
                    if ((file.Attributes & FileAttributes.ReadOnly) !=
                      FileAttributes.ReadOnly)
                    {
                        throw new Exception("Plik nie jest przeznaczony tylko do odczytu.");
                    }
                }
            finally
            {
                if (enumFile.Exists)
                {
                    enumFile.Attributes = FileAttributes.Normal;
                    enumFile.Delete();
                }
            }
            // ...
        }
    }
}
