﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.IO;
using System.Runtime.InteropServices;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07.Listing07_22.Tests
{
    [TestClass]
    public class ProgramTests
    {
        static public void SaveWithData(Action<string> target)
        {
            string data = "Nazywam się Inigo Montoya. Zabiłeś mojego ojca. Przygotuj się na śmierć.";
            string expected = $"ZASZYFROWANE <{data}> ZASZYFROWANE";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, () => target(data)
            );
        }

        [TestMethod]
        public void SaveWithDataTest()
        {
            SaveWithData(Program.Save);
        }


        static public void SaveWithNull(Action<string> targetTest)
        {
            string expected = $"Ostrzeżenie: Nie ma nic do zapisania{Environment.NewLine}";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, ()=>targetTest(null)
            );
        }

        [TestMethod][ExpectedException(typeof(ArgumentNullException))]
        public void SaveWithNullTest()
        {
            SaveWithNull(Program.Save);
        }
    }
}