# EssentialCSharp

Projekt zawiera kod do ksiki **C# 7.0. Kompletny przewodnik dla praktykw**, autor Mark Michaelis (Addison-Wesley/Helion).

## Wskazwki dotyczce przykadowego kodu

Upewnij si, e zainstalowana jest najnowsza wersja jednej z nastpujcych platform.

* [.NET Framework](https://www.microsoft.com/net/targeting) (Windows)
* [.NET Core](https://www.microsoft.com/net/core) (wszystkie systemy)

[Visual Studio 2017](https://www.visualstudio.com) zawiera rodowisko uruchomieniowe .NET Framework, a take umoliwia instalacj .NET Core. Nie wspominajc nawet, e jest to wietne IDE uatwiajce rozpoczcie pracy.

### Pobieranie kodu

#### Kopia lokalna

Otwrz konsol i zmie katalog roboczy na docelow lokalizacj projektu. 
```
$ git clone --recursive https://github.com/IntelliTect/EssentialCSharp.git
$ cd ./EssentialCSharp/
```

**Uwaga:** opcja `--recursive` pozwala pobra podmoduy, a przede wszystkim `IntelliTect.TestTools` (obejmujcy platform testow dla aplikacji konsolowych na platform .NET).

Kod z gazi `master` dotyczy najnowszego wydania ksiki. Jest to ga domylna w instrukcji clone. Moesz jednak wybra inn ga, np. v6.0, uywajc polecenia:
```
$ git checkout v6.0
```

Spolszczona wersja jest dostpna w witrynie wydawnictwa Helion.

### Kompilacja

**EssentialCSharp.sln** to gwne rozwizanie projektu. Otwrz je w Visual Studio i wybierz opcj Kompiluj rozwizanie.
 
 Jeli uywasz wiersza polece, zbuduj wszystkie projekty z katalogu /EssentialCSharp/ za pomoc polece:
```
$ dotnet restore EssentialCSharp.sln
$ dotnet build EssentialCSharp.sln
```
### Uruchamianie

Przejd do projektu w katalogu /EssentialCSharp/src/(projekt)/ i uruchom kod. 
Ten przykad dotyczy rozdziau 1., a uytkownik wpisuje 1.1, aby uruchomi wybrany listing.

```
$ cd ./src/Chapter01/
$ dotnet run
Podaj numer listingu do wykonania (np. dla listingu 18.1 wpisz "18.1"): 1.1

____________________________

Witaj. Nazywam si Inigo Montoya.

____________________________
Koniec listingu 01_01
Wcinij dowolny klawisz, aby kontynuowa.
$
```

Dokumentacj narzdzi z rodziny .NET CLI znajdziesz tu: 

https://docs.microsoft.com/en-us/dotnet/core/tools/


## Testowanie wsadowe

Uyj jednego z poniszych skryptw, aby uruchomi testy wsadowe wszystkich projektw.

* /EssentialCSharp/RunTests.ps1 **(Windows)**
* /EssentialCSharp/RunTests.sh **(Linux/Mac)**

Jeli uywasz Linuksa, moliwe, e musisz nada skryptom uprawnienia do wykonywania. W katalogu /EssentialCSharp/ wykonaj polecenia:
```
$ chmod +x ./RunTests.sh
$ ./RunTests.sh
```
